/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing.diff;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diff.DiffBuilder;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.emftext.language.java.classifiers.Class;
import org.emftext.language.java.classifiers.Enumeration;
import org.emftext.language.java.classifiers.Interface;
import org.emftext.language.java.expressions.Expression;
import org.emftext.language.java.imports.Import;
import org.emftext.language.java.members.Constructor;
import org.emftext.language.java.members.EnumConstant;
import org.emftext.language.java.members.Field;
import org.emftext.language.java.members.Method;
import org.emftext.language.java.modifiers.Final;
import org.emftext.language.java.references.IdentifierReference;
import org.emftext.language.java.references.PackageReference;
import org.emftext.language.java.statements.CatchBlock;
import org.emftext.language.java.statements.NormalSwitchCase;
import org.emftext.language.java.statements.Statement;
import org.emftext.language.java.types.ClassifierReference;
import org.emftext.language.java.types.NamespaceClassifierReference;
import org.emftext.language.java.types.PrimitiveType;
import org.emftext.language.java.variables.AdditionalLocalVariable;
import org.emftext.language.java.variables.Variable;
import org.splevo.jamopp.diffing.diff.JaMoPPChangeFactory;
import org.splevo.jamopp.diffing.scope.PackageIgnoreChecker;

public class JaMoPPDiffBuilder
extends DiffBuilder {
    private Logger logger = Logger.getLogger(JaMoPPDiffBuilder.class);
    private JaMoPPChangeFactory customChangeFactory = new JaMoPPChangeFactory();
    private Map<EObject, Diff> changeCache = new LinkedHashMap<EObject, Diff>();
    private Map<EObject, Diff> addDeleteCache = new LinkedHashMap<EObject, Diff>();
    private List<EObject> resourceAttachementRegistry = new ArrayList<EObject>();
    private PackageIgnoreChecker packageIgnoreChecker = null;

    public JaMoPPDiffBuilder(PackageIgnoreChecker packageIgnoreChecker) {
        this.packageIgnoreChecker = packageIgnoreChecker;
    }

    public void resourceAttachmentChange(Match match, String uri, DifferenceKind kind, DifferenceSource source) {
        EObject changedElement = null;
        changedElement = match.getLeft() != null ? match.getLeft() : match.getRight();
        if (this.packageIgnoreChecker.isInIgnorePackage(changedElement).booleanValue()) {
            this.logger.warn((Object)("Element to ignore: " + changedElement));
        }
        if (this.resourceAttachementRegistry.contains(changedElement)) {
            this.logger.info((Object)("Ressource Attachement Change hit twice: " + changedElement));
            return;
        }
        Diff change = (Diff)this.customChangeFactory.doSwitch(changedElement);
        if (change != null) {
            this.fillStandardFields(change, match, kind, source);
            this.resourceAttachementRegistry.add(changedElement);
            return;
        }
        this.logger.info((Object)("Unhandled Resource Attachment Change (" + kind + ") : left: " + match.getLeft() + ", right: " + match.getRight() + ", source: " + source));
    }

    public void referenceChange(Match match, EReference reference, EObject value, DifferenceKind kind, DifferenceSource source) {
        Match nextParent;
        if ("defaultExtends".equals(reference.getName())) {
            return;
        }
        if (reference.isContainment()) {
            if (this.addDeleteCache.containsKey(value)) {
                return;
            }
            Diff change = (Diff)this.customChangeFactory.doSwitch(value);
            if (change != null) {
                this.fillStandardFields(change, match, kind, source);
                this.addDeleteCache.put(value, change);
                return;
            }
        }
        if ((value instanceof EnumConstant || value instanceof Expression || value instanceof Class || value instanceof Interface || value instanceof Method || value instanceof Constructor || value instanceof Variable || value instanceof AdditionalLocalVariable || value instanceof ClassifierReference || value instanceof Final || value instanceof CatchBlock || value instanceof NamespaceClassifierReference || value instanceof PackageReference || value instanceof IdentifierReference || value instanceof PrimitiveType || value instanceof NormalSwitchCase) && (nextParent = this.nextResonableMatch(match)) != null) {
            EObject parentObject = null;
            if (nextParent.getLeft() != null) {
                parentObject = nextParent.getLeft();
            } else if (nextParent.getRight() != null) {
                parentObject = nextParent.getRight();
            }
            if (!this.changeRegisteredBefore(parentObject)) {
                Diff change = (Diff)this.customChangeFactory.doSwitch(parentObject);
                this.fillStandardFields(change, nextParent, DifferenceKind.CHANGE, source);
                this.changeCache.put(parentObject, change);
            }
            return;
        }
        this.logger.info((Object)("Unhandled Reference Change (" + kind + ") :" + reference.getName() + ", left: " + match.getLeft() + ", right: " + match.getRight() + ", value: " + value));
    }

    public void attributeChange(Match match, EAttribute attribute, Object value, DifferenceKind kind, DifferenceSource source) {
        this.logger.info((Object)("Attribute Change (" + kind + ") :" + attribute.getName() + ", left: " + match.getLeft() + ", right: " + match.getRight() + ", value: " + value));
        super.attributeChange(match, attribute, value, kind, source);
    }

    private Match nextResonableMatch(Match match) {
        if (match == null) {
            return null;
        }
        EObject parentObject = null;
        parentObject = match.getLeft() != null ? match.getLeft() : match.getRight();
        if (parentObject instanceof Class) {
            return match;
        }
        if (parentObject instanceof Field) {
            return match;
        }
        if (parentObject instanceof Method) {
            return match;
        }
        if (parentObject instanceof Constructor) {
            return match;
        }
        if (parentObject instanceof Package) {
            return match;
        }
        if (parentObject instanceof Enumeration) {
            return match;
        }
        if (parentObject instanceof Import) {
            return match;
        }
        if (parentObject instanceof Statement) {
            return match;
        }
        if (match.eContainer() instanceof Match) {
            return this.nextResonableMatch((Match)match.eContainer());
        }
        return null;
    }

    public void createRootDiff(Match match) {
        if (match.getLeft() == null) {
            EObject value = match.getRight();
            if (this.changeRegisteredBefore(value)) {
                return;
            }
            Diff diff = (Diff)this.customChangeFactory.doSwitch(value);
            diff.setSource(DifferenceSource.RIGHT);
            diff.setKind(DifferenceKind.DELETE);
            diff.setMatch(match);
            this.changeCache.put(value, diff);
        } else {
            EObject value = match.getLeft();
            if (this.changeRegisteredBefore(value)) {
                return;
            }
            Diff diff = (Diff)this.customChangeFactory.doSwitch(value);
            diff.setSource(DifferenceSource.LEFT);
            diff.setKind(DifferenceKind.ADD);
            diff.setMatch(match);
            this.changeCache.put(value, diff);
        }
    }

    private boolean changeRegisteredBefore(EObject value) {
        if (this.resourceAttachementRegistry.contains(value)) {
            this.logger.debug((Object)("Ressource Attachement Change hit twice: " + value));
            return true;
        }
        return this.changeCache.containsKey(value);
    }

    private void fillStandardFields(Diff diff, Match match, DifferenceKind kind, DifferenceSource source) {
        diff.setKind(kind);
        diff.setMatch(match);
        diff.setSource(source);
    }
}

