/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing.similarity;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.Switch;
import org.emftext.commons.layout.util.LayoutSwitch;
import org.emftext.language.java.annotations.AnnotationAttributeSetting;
import org.emftext.language.java.annotations.AnnotationInstance;
import org.emftext.language.java.annotations.util.AnnotationsSwitch;
import org.emftext.language.java.arrays.ArraySelector;
import org.emftext.language.java.arrays.util.ArraysSwitch;
import org.emftext.language.java.classifiers.AnonymousClass;
import org.emftext.language.java.classifiers.Classifier;
import org.emftext.language.java.classifiers.ConcreteClassifier;
import org.emftext.language.java.classifiers.util.ClassifiersSwitch;
import org.emftext.language.java.commons.Commentable;
import org.emftext.language.java.commons.NamedElement;
import org.emftext.language.java.commons.util.CommonsSwitch;
import org.emftext.language.java.containers.CompilationUnit;
import org.emftext.language.java.containers.Package;
import org.emftext.language.java.containers.util.ContainersSwitch;
import org.emftext.language.java.expressions.AndExpression;
import org.emftext.language.java.expressions.AssignmentExpression;
import org.emftext.language.java.expressions.AssignmentExpressionChild;
import org.emftext.language.java.expressions.ConditionalAndExpression;
import org.emftext.language.java.expressions.ConditionalOrExpression;
import org.emftext.language.java.expressions.EqualityExpression;
import org.emftext.language.java.expressions.Expression;
import org.emftext.language.java.expressions.InstanceOfExpression;
import org.emftext.language.java.expressions.InstanceOfExpressionChild;
import org.emftext.language.java.expressions.NestedExpression;
import org.emftext.language.java.expressions.RelationExpression;
import org.emftext.language.java.expressions.UnaryExpression;
import org.emftext.language.java.expressions.UnaryExpressionChild;
import org.emftext.language.java.expressions.util.ExpressionsSwitch;
import org.emftext.language.java.generics.util.GenericsSwitch;
import org.emftext.language.java.imports.ClassifierImport;
import org.emftext.language.java.imports.StaticMemberImport;
import org.emftext.language.java.imports.util.ImportsSwitch;
import org.emftext.language.java.instantiations.ExplicitConstructorCall;
import org.emftext.language.java.instantiations.NewConstructorCall;
import org.emftext.language.java.instantiations.util.InstantiationsSwitch;
import org.emftext.language.java.literals.BooleanLiteral;
import org.emftext.language.java.literals.CharacterLiteral;
import org.emftext.language.java.literals.DecimalDoubleLiteral;
import org.emftext.language.java.literals.DecimalFloatLiteral;
import org.emftext.language.java.literals.DecimalIntegerLiteral;
import org.emftext.language.java.literals.DecimalLongLiteral;
import org.emftext.language.java.literals.HexDoubleLiteral;
import org.emftext.language.java.literals.HexFloatLiteral;
import org.emftext.language.java.literals.HexIntegerLiteral;
import org.emftext.language.java.literals.HexLongLiteral;
import org.emftext.language.java.literals.OctalIntegerLiteral;
import org.emftext.language.java.literals.OctalLongLiteral;
import org.emftext.language.java.literals.util.LiteralsSwitch;
import org.emftext.language.java.members.Constructor;
import org.emftext.language.java.members.EnumConstant;
import org.emftext.language.java.members.Member;
import org.emftext.language.java.members.Method;
import org.emftext.language.java.members.util.MembersSwitch;
import org.emftext.language.java.modifiers.util.ModifiersSwitch;
import org.emftext.language.java.operators.AssignmentOperator;
import org.emftext.language.java.operators.util.OperatorsSwitch;
import org.emftext.language.java.parameters.OrdinaryParameter;
import org.emftext.language.java.parameters.Parameter;
import org.emftext.language.java.parameters.util.ParametersSwitch;
import org.emftext.language.java.references.ElementReference;
import org.emftext.language.java.references.IdentifierReference;
import org.emftext.language.java.references.MethodCall;
import org.emftext.language.java.references.Reference;
import org.emftext.language.java.references.ReferenceableElement;
import org.emftext.language.java.references.StringReference;
import org.emftext.language.java.references.util.ReferencesSwitch;
import org.emftext.language.java.statements.CatchBlock;
import org.emftext.language.java.statements.Conditional;
import org.emftext.language.java.statements.ExpressionStatement;
import org.emftext.language.java.statements.Jump;
import org.emftext.language.java.statements.JumpLabel;
import org.emftext.language.java.statements.LocalVariableStatement;
import org.emftext.language.java.statements.Return;
import org.emftext.language.java.statements.Statement;
import org.emftext.language.java.statements.StatementListContainer;
import org.emftext.language.java.statements.SynchronizedBlock;
import org.emftext.language.java.statements.Throw;
import org.emftext.language.java.statements.util.StatementsSwitch;
import org.emftext.language.java.types.ClassifierReference;
import org.emftext.language.java.types.NamespaceClassifierReference;
import org.emftext.language.java.types.PrimitiveType;
import org.emftext.language.java.types.Type;
import org.emftext.language.java.types.TypeReference;
import org.emftext.language.java.types.util.TypesSwitch;
import org.emftext.language.java.variables.AdditionalLocalVariable;
import org.emftext.language.java.variables.LocalVariable;
import org.emftext.language.java.variables.Variable;
import org.emftext.language.java.variables.util.VariablesSwitch;
import org.splevo.diffing.util.NormalizationUtil;
import org.splevo.jamopp.diffing.similarity.SimilarityChecker;
import org.splevo.jamopp.diffing.util.JaMoPPModelUtil;
import org.splevo.jamopp.util.JaMoPPElementUtil;

public class SimilaritySwitch
extends ComposedSwitch<Boolean> {
    private Logger logger = Logger.getLogger(SimilaritySwitch.class);
    private EObject compareElement = null;
    private SimilarityChecker similarityChecker = null;

    public SimilaritySwitch(EObject compareElement, boolean checkStatementPosition, LinkedHashMap<Pattern, String> classifierNormalizations, LinkedHashMap<Pattern, String> compilationUnitNormalizations, LinkedHashMap<Pattern, String> packageNormalizations) {
        this.similarityChecker = new SimilarityChecker(classifierNormalizations, compilationUnitNormalizations, packageNormalizations);
        this.compareElement = compareElement;
        this.addSwitch((Switch)new AnnotationsSimilaritySwitch());
        this.addSwitch((Switch)new ArraysSimilaritySwitch());
        this.addSwitch((Switch)new ClassifiersSimilaritySwitch(classifierNormalizations));
        this.addSwitch((Switch)new CommonsSimilaritySwitch());
        this.addSwitch((Switch)new ContainersSimilaritySwitch(compilationUnitNormalizations, packageNormalizations));
        this.addSwitch((Switch)new ExpressionsSimilaritySwitch());
        this.addSwitch((Switch)new GenericsSimilaritySwitch());
        this.addSwitch((Switch)new ImportsSimilaritySwitch());
        this.addSwitch((Switch)new InstantiationsSimilaritySwitch());
        this.addSwitch((Switch)new LiteralsSimilaritySwitch());
        this.addSwitch((Switch)new MembersSimilaritySwitch());
        this.addSwitch((Switch)new ModifiersSimilaritySwitch());
        this.addSwitch((Switch)new OperatorsSimilaritySwitch());
        this.addSwitch((Switch)new ParametersSimilaritySwitch());
        this.addSwitch((Switch)new ReferencesSimilaritySwitch());
        this.addSwitch((Switch)new StatementsSimilaritySwitch(checkStatementPosition));
        this.addSwitch((Switch)new TypesSimilaritySwitch());
        this.addSwitch((Switch)new VariablesSimilaritySwitch());
        this.addSwitch((Switch)new LayoutSimilaritySwitch());
    }

    public Boolean defaultCase(EObject object) {
        return Boolean.TRUE;
    }

    private class AnnotationsSimilaritySwitch
    extends AnnotationsSwitch<Boolean> {
        private AnnotationsSimilaritySwitch() {
        }

        public Boolean caseAnnotationInstance(AnnotationInstance instance1) {
            AnnotationInstance instance2 = (AnnotationInstance)SimilaritySwitch.this.compareElement;
            Classifier class1 = instance1.getAnnotation();
            Classifier class2 = instance2.getAnnotation();
            Boolean classifierSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)class1, (EObject)class2);
            if (classifierSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            String namespace1 = instance1.getNamespacesAsString();
            String namespace2 = instance2.getNamespacesAsString();
            if (namespace1 == null) {
                if (namespace2 == null) {
                    return true;
                }
                return false;
            }
            return namespace1.equals(namespace2);
        }

        public Boolean caseAnnotationAttributeSetting(AnnotationAttributeSetting setting1) {
            AnnotationAttributeSetting setting2 = (AnnotationAttributeSetting)SimilaritySwitch.this.compareElement;
            Boolean similarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)setting1.getAttribute(), (EObject)setting2.getAttribute());
            if (similarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.TRUE;
        }
    }

    private class ArraysSimilaritySwitch
    extends ArraysSwitch<Boolean> {
        private ArraysSimilaritySwitch() {
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.TRUE;
        }
    }

    private class ClassifiersSimilaritySwitch
    extends ClassifiersSwitch<Boolean> {
        private Map<Pattern, String> classifierNormalizationPatterns = null;

        public ClassifiersSimilaritySwitch(Map<Pattern, String> classifierNormalizationPatterns) {
            this.classifierNormalizationPatterns = classifierNormalizationPatterns;
        }

        public Boolean caseConcreteClassifier(ConcreteClassifier classifier1) {
            ConcreteClassifier classifier2 = (ConcreteClassifier)SimilaritySwitch.this.compareElement;
            String name1 = NormalizationUtil.normalize((String)classifier1.getName(), this.classifierNormalizationPatterns);
            String name2 = Strings.nullToEmpty((String)classifier2.getName());
            return name1.equals(name2);
        }
    }

    private class CommonsSimilaritySwitch
    extends CommonsSwitch<Boolean> {
        private CommonsSimilaritySwitch() {
        }

        public Boolean caseNamedElement(NamedElement element1) {
            NamedElement element2 = (NamedElement)SimilaritySwitch.this.compareElement;
            if (element1.getName() == null) {
                if (element2.getName() == null) {
                    return true;
                }
                return false;
            }
            return element1.getName().equals(element2.getName());
        }
    }

    private class ContainersSimilaritySwitch
    extends ContainersSwitch<Boolean> {
        private LinkedHashMap<Pattern, String> compilationUnitNormalizations = null;
        private LinkedHashMap<Pattern, String> packageNormalizations = null;

        public ContainersSimilaritySwitch(LinkedHashMap<Pattern, String> compilationUnitNormalizations, LinkedHashMap<Pattern, String> packageNormalizations) {
            this.compilationUnitNormalizations = compilationUnitNormalizations;
            this.packageNormalizations = packageNormalizations;
        }

        public Boolean caseCompilationUnit(CompilationUnit unit1) {
            String namespaceString2;
            String name2;
            CompilationUnit unit2 = (CompilationUnit)SimilaritySwitch.this.compareElement;
            String name1 = NormalizationUtil.normalize((String)unit1.getName(), this.compilationUnitNormalizations);
            if (!(name1 = NormalizationUtil.normalize((String)name1, this.packageNormalizations)).equals(name2 = unit2.getName())) {
                return Boolean.FALSE;
            }
            String namespaceString1 = NormalizationUtil.normalizeNamespace((String)unit1.getNamespacesAsString(), this.packageNormalizations);
            if (!namespaceString1.equals(namespaceString2 = Strings.nullToEmpty((String)unit2.getNamespacesAsString()))) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean casePackage(Package package1) {
            String packagePath2;
            Package package2 = (Package)SimilaritySwitch.this.compareElement;
            String packagePath1 = JaMoPPModelUtil.buildNamespacePath((EObject)package1);
            if (!(packagePath1 = NormalizationUtil.normalizeNamespace((String)packagePath1, this.packageNormalizations)).equals(packagePath2 = JaMoPPModelUtil.buildNamespacePath((EObject)package2))) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
    }

    private class ExpressionsSimilaritySwitch
    extends ExpressionsSwitch<Boolean> {
        private ExpressionsSimilaritySwitch() {
        }

        public Boolean caseAssignmentExpression(AssignmentExpression exp1) {
            AssignmentExpression exp2 = (AssignmentExpression)SimilaritySwitch.this.compareElement;
            AssignmentExpressionChild child1 = exp1.getChild();
            AssignmentExpressionChild child2 = exp2.getChild();
            Boolean childSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)child1, (EObject)child2);
            if (childSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            AssignmentOperator op1 = exp1.getAssignmentOperator();
            AssignmentOperator op2 = exp2.getAssignmentOperator();
            Boolean operatorSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)op1, (EObject)op2);
            if (operatorSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            Expression value1 = exp1.getValue();
            Expression value2 = exp2.getValue();
            Boolean valueSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)value1, (EObject)value2);
            if (valueSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean caseEqualityExpression(EqualityExpression exp1) {
            EqualityExpression exp2 = (EqualityExpression)SimilaritySwitch.this.compareElement;
            EList operators1 = exp1.getEqualityOperators();
            EList operators2 = exp2.getEqualityOperators();
            Boolean operatorSimilarity = SimilaritySwitch.this.similarityChecker.areSimilar((List<? extends EObject>)operators1, (List<? extends EObject>)operators2);
            if (operatorSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            EList children1 = exp1.getChildren();
            EList children2 = exp2.getChildren();
            Boolean childSimilarity = SimilaritySwitch.this.similarityChecker.areSimilar((List<? extends EObject>)children1, (List<? extends EObject>)children2);
            if (childSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean caseRelationExpression(RelationExpression exp1) {
            RelationExpression exp2 = (RelationExpression)SimilaritySwitch.this.compareElement;
            EList operators1 = exp1.getRelationOperators();
            EList operators2 = exp2.getRelationOperators();
            Boolean operatorSimilarity = SimilaritySwitch.this.similarityChecker.areSimilar((List<? extends EObject>)operators1, (List<? extends EObject>)operators2);
            if (operatorSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            EList children1 = exp1.getChildren();
            EList children2 = exp2.getChildren();
            Boolean childSimilarity = SimilaritySwitch.this.similarityChecker.areSimilar((List<? extends EObject>)children1, (List<? extends EObject>)children2);
            if (childSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean caseAndExpression(AndExpression exp1) {
            AndExpression exp2 = (AndExpression)SimilaritySwitch.this.compareElement;
            EList children1 = exp1.getChildren();
            EList children2 = exp2.getChildren();
            Boolean childSimilarity = SimilaritySwitch.this.similarityChecker.areSimilar((List<? extends EObject>)children1, (List<? extends EObject>)children2);
            if (childSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean caseUnaryExpression(UnaryExpression exp1) {
            UnaryExpression exp2 = (UnaryExpression)SimilaritySwitch.this.compareElement;
            EList operators1 = exp1.getOperators();
            EList operators2 = exp2.getOperators();
            Boolean operatorSimilarity = SimilaritySwitch.this.similarityChecker.areSimilar((List<? extends EObject>)operators1, (List<? extends EObject>)operators2);
            if (operatorSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            UnaryExpressionChild child1 = exp1.getChild();
            UnaryExpressionChild child2 = exp2.getChild();
            return SimilaritySwitch.this.similarityChecker.isSimilar((EObject)child1, (EObject)child2);
        }

        public Boolean caseInstanceOfExpression(InstanceOfExpression exp1) {
            InstanceOfExpression exp2 = (InstanceOfExpression)SimilaritySwitch.this.compareElement;
            TypeReference typeReference1 = exp1.getTypeReference();
            TypeReference typeReference2 = exp2.getTypeReference();
            Boolean typeSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)typeReference1, (EObject)typeReference2);
            if (typeSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            InstanceOfExpressionChild child1 = exp1.getChild();
            InstanceOfExpressionChild child2 = exp2.getChild();
            return SimilaritySwitch.this.similarityChecker.isSimilar((EObject)child1, (EObject)child2);
        }

        public Boolean caseConditionalOrExpression(ConditionalOrExpression exp1) {
            ConditionalOrExpression exp2 = (ConditionalOrExpression)SimilaritySwitch.this.compareElement;
            EList children1 = exp1.getChildren();
            EList children2 = exp2.getChildren();
            return SimilaritySwitch.this.similarityChecker.areSimilar((List<? extends EObject>)children1, (List<? extends EObject>)children2);
        }

        public Boolean caseConditionalAndExpression(ConditionalAndExpression exp1) {
            ConditionalAndExpression exp2 = (ConditionalAndExpression)SimilaritySwitch.this.compareElement;
            EList children1 = exp1.getChildren();
            EList children2 = exp2.getChildren();
            return SimilaritySwitch.this.similarityChecker.areSimilar((List<? extends EObject>)children1, (List<? extends EObject>)children2);
        }

        public Boolean caseNestedExpression(NestedExpression exp1) {
            NestedExpression exp2 = (NestedExpression)SimilaritySwitch.this.compareElement;
            Expression childExp1 = exp1.getExpression();
            Expression childExp2 = exp2.getExpression();
            return SimilaritySwitch.this.similarityChecker.isSimilar((EObject)childExp1, (EObject)childExp2);
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.TRUE;
        }
    }

    private class GenericsSimilaritySwitch
    extends GenericsSwitch<Boolean> {
        private GenericsSimilaritySwitch() {
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.TRUE;
        }
    }

    private class ImportsSimilaritySwitch
    extends ImportsSwitch<Boolean> {
        private ImportsSimilaritySwitch() {
        }

        public Boolean caseClassifierImport(ClassifierImport import1) {
            ClassifierImport import2 = (ClassifierImport)SimilaritySwitch.this.compareElement;
            Boolean similarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)import1.getClassifier(), (EObject)import2.getClassifier());
            if (similarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            String namespace1 = Strings.nullToEmpty((String)import1.getNamespacesAsString());
            String namespace2 = Strings.nullToEmpty((String)import2.getNamespacesAsString());
            return namespace1.equals(namespace2);
        }

        public Boolean caseStaticMemberImport(StaticMemberImport import1) {
            StaticMemberImport import2 = (StaticMemberImport)SimilaritySwitch.this.compareElement;
            if (import1.getStaticMembers().size() != import2.getStaticMembers().size()) {
                return Boolean.FALSE;
            }
            int i = 0;
            while (i < import1.getStaticMembers().size()) {
                ReferenceableElement member1 = (ReferenceableElement)import1.getStaticMembers().get(i);
                ReferenceableElement member2 = (ReferenceableElement)import2.getStaticMembers().get(i);
                Boolean similarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)member1, (EObject)member2);
                if (similarity == Boolean.FALSE) {
                    return Boolean.FALSE;
                }
                ++i;
            }
            String namespace1 = Strings.nullToEmpty((String)import1.getNamespacesAsString());
            String namespace2 = Strings.nullToEmpty((String)import2.getNamespacesAsString());
            return namespace1.equals(namespace2);
        }
    }

    private class InstantiationsSimilaritySwitch
    extends InstantiationsSwitch<Boolean> {
        private InstantiationsSimilaritySwitch() {
        }

        public Boolean caseExplicitConstructorCall(ExplicitConstructorCall call1) {
            ExplicitConstructorCall call2 = (ExplicitConstructorCall)SimilaritySwitch.this.compareElement;
            Boolean typeSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)call1.getType(), (EObject)call2.getType());
            if (typeSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            EList cic1Args = call1.getArguments();
            EList cic2Args = call2.getArguments();
            if (cic1Args.size() != cic2Args.size()) {
                return Boolean.FALSE;
            }
            int i = 0;
            while (i < cic1Args.size()) {
                Boolean argumentSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)cic1Args.get(i), (EObject)cic2Args.get(i));
                if (argumentSimilarity == Boolean.FALSE) {
                    return Boolean.FALSE;
                }
                ++i;
            }
            return Boolean.TRUE;
        }

        public Boolean caseNewConstructorCall(NewConstructorCall call1) {
            NewConstructorCall call2 = (NewConstructorCall)SimilaritySwitch.this.compareElement;
            Type type1 = call1.getTypeReference().getTarget();
            Type type2 = call2.getTypeReference().getTarget();
            Boolean typeSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)type1, (EObject)type2);
            if (typeSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            EList types1 = call1.getArgumentTypes();
            EList types2 = call2.getArgumentTypes();
            if (types1.size() != types2.size()) {
                return Boolean.FALSE;
            }
            int i = 0;
            while (i < types1.size()) {
                Type argType1 = (Type)types1.get(i);
                Type argType2 = (Type)types2.get(i);
                Boolean similarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)argType1, (EObject)argType2);
                if (similarity == Boolean.FALSE) {
                    return Boolean.FALSE;
                }
                ++i;
            }
            return Boolean.TRUE;
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.TRUE;
        }
    }

    private class LayoutSimilaritySwitch
    extends LayoutSwitch<Boolean> {
        private LayoutSimilaritySwitch() {
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.TRUE;
        }
    }

    private class LiteralsSimilaritySwitch
    extends LiteralsSwitch<Boolean> {
        private LiteralsSimilaritySwitch() {
        }

        public Boolean caseBooleanLiteral(BooleanLiteral boolean1) {
            BooleanLiteral boolean2 = (BooleanLiteral)SimilaritySwitch.this.compareElement;
            if (boolean1.isValue() == boolean2.isValue()) {
                return true;
            }
            return false;
        }

        public Boolean caseCharacterLiteral(CharacterLiteral char1) {
            CharacterLiteral char2 = (CharacterLiteral)SimilaritySwitch.this.compareElement;
            if (char1.getValue() == char2.getValue()) {
                return true;
            }
            return false;
        }

        public Boolean caseDecimalFloatLiteral(DecimalFloatLiteral float1) {
            DecimalFloatLiteral float2 = (DecimalFloatLiteral)SimilaritySwitch.this.compareElement;
            if (float1.getDecimalValue() == float2.getDecimalValue()) {
                return true;
            }
            return false;
        }

        public Boolean caseHexFloatLiteral(HexFloatLiteral float1) {
            HexFloatLiteral float2 = (HexFloatLiteral)SimilaritySwitch.this.compareElement;
            if (float1.getHexValue() == float2.getHexValue()) {
                return true;
            }
            return false;
        }

        public Boolean caseDecimalDoubleLiteral(DecimalDoubleLiteral double1) {
            DecimalDoubleLiteral double2 = (DecimalDoubleLiteral)SimilaritySwitch.this.compareElement;
            if (double1.getDecimalValue() == double2.getDecimalValue()) {
                return true;
            }
            return false;
        }

        public Boolean caseHexDoubleLiteral(HexDoubleLiteral double1) {
            HexDoubleLiteral double2 = (HexDoubleLiteral)SimilaritySwitch.this.compareElement;
            if (double1.getHexValue() == double2.getHexValue()) {
                return true;
            }
            return false;
        }

        public Boolean caseDecimalIntegerLiteral(DecimalIntegerLiteral int1) {
            DecimalIntegerLiteral int2 = (DecimalIntegerLiteral)SimilaritySwitch.this.compareElement;
            return int1.getDecimalValue().equals(int2.getDecimalValue());
        }

        public Boolean caseHexIntegerLiteral(HexIntegerLiteral int1) {
            HexIntegerLiteral int2 = (HexIntegerLiteral)SimilaritySwitch.this.compareElement;
            return int1.getHexValue().equals(int2.getHexValue());
        }

        public Boolean caseOctalIntegerLiteral(OctalIntegerLiteral int1) {
            OctalIntegerLiteral int2 = (OctalIntegerLiteral)SimilaritySwitch.this.compareElement;
            return int1.getOctalValue().equals(int2.getOctalValue());
        }

        public Boolean caseDecimalLongLiteral(DecimalLongLiteral long1) {
            DecimalLongLiteral long2 = (DecimalLongLiteral)SimilaritySwitch.this.compareElement;
            return long1.getDecimalValue().equals(long2.getDecimalValue());
        }

        public Boolean caseHexLongLiteral(HexLongLiteral long1) {
            HexLongLiteral long2 = (HexLongLiteral)SimilaritySwitch.this.compareElement;
            return long1.getHexValue().equals(long2.getHexValue());
        }

        public Boolean caseOctalLongLiteral(OctalLongLiteral long1) {
            OctalLongLiteral long2 = (OctalLongLiteral)SimilaritySwitch.this.compareElement;
            return long1.getOctalValue().equals(long2.getOctalValue());
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.TRUE;
        }
    }

    private class MembersSimilaritySwitch
    extends MembersSwitch<Boolean> {
        private MembersSimilaritySwitch() {
        }

        public Boolean caseMethod(Method method1) {
            ConcreteClassifier type2;
            Method method2 = (Method)SimilaritySwitch.this.compareElement;
            if (!method1.getName().equals(method2.getName())) {
                return Boolean.FALSE;
            }
            if (method1.getParameters().size() != method2.getParameters().size()) {
                return Boolean.FALSE;
            }
            int i = 0;
            while (i < method1.getParameters().size()) {
                Parameter param1 = (Parameter)method1.getParameters().get(i);
                Parameter param2 = (Parameter)method2.getParameters().get(i);
                Type type1 = param1.getTypeReference().getTarget();
                Type type22 = param2.getTypeReference().getTarget();
                Boolean typeSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)type1, (EObject)type22);
                if (typeSimilarity == Boolean.FALSE) {
                    return Boolean.FALSE;
                }
                ++i;
            }
            if (method1.getContainingConcreteClassifier() != null) {
                ConcreteClassifier type1 = method1.getContainingConcreteClassifier();
                type2 = method2.getContainingConcreteClassifier();
                return SimilaritySwitch.this.similarityChecker.isSimilar((EObject)type1, (EObject)type2);
            }
            if (method1.getContainingAnonymousClass() != null) {
                AnonymousClass type1 = method1.getContainingAnonymousClass();
                type2 = method2.getContainingAnonymousClass();
                Boolean typeSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)type1, (EObject)type2);
                if (typeSimilarity != null) {
                    return typeSimilarity;
                }
            }
            SimilaritySwitch.this.logger.warn((Object)("MethodDeclaration in unknown container: " + method1.getName() + " : " + method1.eContainer().getClass().getSimpleName()));
            return (Boolean)super.caseMethod(method1);
        }

        public Boolean caseConstructor(Constructor constructor1) {
            Constructor constructor2 = (Constructor)SimilaritySwitch.this.compareElement;
            if (!constructor1.getName().equals(constructor2.getName())) {
                return Boolean.FALSE;
            }
            EList params1 = constructor1.getParameters();
            EList params2 = constructor2.getParameters();
            Boolean parameterSimilarity = SimilaritySwitch.this.similarityChecker.areSimilar((List<? extends EObject>)params1, (List<? extends EObject>)params2);
            if (parameterSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            if (constructor1.getContainingConcreteClassifier() != null) {
                ConcreteClassifier type1 = constructor1.getContainingConcreteClassifier();
                ConcreteClassifier type2 = constructor2.getContainingConcreteClassifier();
                return SimilaritySwitch.this.similarityChecker.isSimilar((EObject)type1, (EObject)type2);
            }
            if (constructor1.getContainingAnonymousClass() != null) {
                AnonymousClass type1 = constructor1.getContainingAnonymousClass();
                AnonymousClass type2 = constructor2.getContainingAnonymousClass();
                Boolean typeSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)type1, (EObject)type2);
                if (typeSimilarity != null) {
                    return typeSimilarity;
                }
            }
            SimilaritySwitch.this.logger.warn((Object)("ConstructorDeclaration in unknown container: " + constructor1.getName() + " : " + constructor1.eContainer().getClass().getSimpleName()));
            return (Boolean)super.caseConstructor(constructor1);
        }

        public Boolean caseEnumConstant(EnumConstant const1) {
            EnumConstant const2 = (EnumConstant)SimilaritySwitch.this.compareElement;
            String name1 = Strings.nullToEmpty((String)const1.getName());
            String name2 = Strings.nullToEmpty((String)const2.getName());
            return name1.equals(name2);
        }

        public Boolean caseMember(Member member1) {
            Member member2 = (Member)SimilaritySwitch.this.compareElement;
            String name1 = Strings.nullToEmpty((String)member1.getName());
            String name2 = Strings.nullToEmpty((String)member2.getName());
            return name1.equals(name2);
        }
    }

    private class ModifiersSimilaritySwitch
    extends ModifiersSwitch<Boolean> {
        private ModifiersSimilaritySwitch() {
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.TRUE;
        }
    }

    private class OperatorsSimilaritySwitch
    extends OperatorsSwitch<Boolean> {
        private OperatorsSimilaritySwitch() {
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.TRUE;
        }
    }

    private class ParametersSimilaritySwitch
    extends ParametersSwitch<Boolean> {
        private ParametersSimilaritySwitch() {
        }

        public Boolean caseParameter(Parameter param1) {
            Parameter param2 = (Parameter)SimilaritySwitch.this.compareElement;
            String name1 = Strings.nullToEmpty((String)param1.getName());
            String name2 = Strings.nullToEmpty((String)param2.getName());
            return name1.equals(name2);
        }
    }

    private class ReferencesSimilaritySwitch
    extends ReferencesSwitch<Boolean> {
        private ReferencesSimilaritySwitch() {
        }

        public Boolean caseStringReference(StringReference ref1) {
            StringReference ref2 = (StringReference)SimilaritySwitch.this.compareElement;
            if (ref1.getValue() == null) {
                if (ref2.getValue() == null) {
                    return true;
                }
                return false;
            }
            return ref1.getValue().equals(ref2.getValue());
        }

        public Boolean caseIdentifierReference(IdentifierReference ref1) {
            IdentifierReference ref2 = (IdentifierReference)SimilaritySwitch.this.compareElement;
            ReferenceableElement target1 = ref1.getTarget();
            ReferenceableElement target2 = ref2.getTarget();
            Boolean similarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)target1, (EObject)target2);
            if (similarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            if (target1 != null) {
                Boolean containerSimilarity;
                EObject ref1Container = JaMoPPElementUtil.getFirstContainerNotOfGivenType((Commentable)ref1, (Class[])new Class[]{Expression.class, ArraySelector.class});
                EObject ref2Container = JaMoPPElementUtil.getFirstContainerNotOfGivenType((Commentable)ref2, (Class[])new Class[]{Expression.class, ArraySelector.class});
                EObject target1Container = target1.eContainer();
                EObject target2Container = target2.eContainer();
                if (target1Container != ref1Container && target2Container != ref2Container && (containerSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar(target1Container, target2Container)) == Boolean.FALSE) {
                    return Boolean.FALSE;
                }
            }
            if (ref1.getArraySelectors().size() != ref2.getArraySelectors().size()) {
                return Boolean.FALSE;
            }
            int i = 0;
            while (i < ref1.getArraySelectors().size()) {
                ArraySelector selector1 = (ArraySelector)ref1.getArraySelectors().get(i);
                ArraySelector selector2 = (ArraySelector)ref2.getArraySelectors().get(i);
                Boolean positionSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)selector1.getPosition(), (EObject)selector2.getPosition());
                if (positionSimilarity == Boolean.FALSE) {
                    return Boolean.FALSE;
                }
                ++i;
            }
            Reference next1 = ref1.getNext();
            Reference next2 = ref2.getNext();
            Boolean nextSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)next1, (EObject)next2);
            if (nextSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean caseElementReference(ElementReference ref1) {
            ElementReference ref2 = (ElementReference)SimilaritySwitch.this.compareElement;
            Boolean targetSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)ref1.getTarget(), (EObject)ref2.getTarget());
            if (targetSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean caseMethodCall(MethodCall call1) {
            MethodCall call2 = (MethodCall)SimilaritySwitch.this.compareElement;
            Boolean targetSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)call1.getTarget(), (EObject)call2.getTarget());
            if (targetSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            if (call1.getArguments().size() != call2.getArguments().size()) {
                return Boolean.FALSE;
            }
            int i = 0;
            while (i < call1.getArguments().size()) {
                Expression exp1 = (Expression)call1.getArguments().get(i);
                Expression exp2 = (Expression)call2.getArguments().get(i);
                Boolean argSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)exp1, (EObject)exp2);
                if (argSimilarity == Boolean.FALSE) {
                    return Boolean.FALSE;
                }
                ++i;
            }
            Boolean nextSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)call1.getNext(), (EObject)call2.getNext());
            if (nextSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.TRUE;
        }
    }

    private class StatementsSimilaritySwitch
    extends StatementsSwitch<Boolean> {
        private boolean checkStatementPosition = true;

        public StatementsSimilaritySwitch(boolean checkStatementPosition) {
            this.checkStatementPosition = checkStatementPosition;
        }

        public Boolean caseExpressionStatement(ExpressionStatement statement1) {
            ExpressionStatement statement2 = (ExpressionStatement)SimilaritySwitch.this.compareElement;
            Expression exp1 = statement1.getExpression();
            Expression exp2 = statement2.getExpression();
            Boolean expSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)exp1, (EObject)exp2);
            if (expSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            if (this.checkStatementPosition && this.differentPredecessor((Statement)statement1, (Statement)statement2) && this.differentSuccessor((Statement)statement1, (Statement)statement2)) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean caseLocalVariableStatement(LocalVariableStatement varStmt1) {
            LocalVariableStatement varStmt2 = (LocalVariableStatement)SimilaritySwitch.this.compareElement;
            LocalVariable var1 = varStmt1.getVariable();
            LocalVariable var2 = varStmt2.getVariable();
            Boolean varSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)var1, (EObject)var2);
            if (varSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean caseReturn(Return returnStatement1) {
            Return returnStatement2 = (Return)SimilaritySwitch.this.compareElement;
            Expression exp1 = returnStatement1.getReturnValue();
            Expression exp2 = returnStatement2.getReturnValue();
            return SimilaritySwitch.this.similarityChecker.isSimilar((EObject)exp1, (EObject)exp2);
        }

        public Boolean caseSynchronizedBlock(SynchronizedBlock statement1) {
            SynchronizedBlock statement2 = (SynchronizedBlock)SimilaritySwitch.this.compareElement;
            Expression exp1 = statement1.getLockProvider();
            Expression exp2 = statement2.getLockProvider();
            Boolean similarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)exp1, (EObject)exp2);
            if (similarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            if (this.checkStatementPosition && this.differentPredecessor((Statement)statement1, (Statement)statement2) && this.differentSuccessor((Statement)statement1, (Statement)statement2)) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean caseThrow(Throw throwStatement1) {
            return Boolean.TRUE;
        }

        public Boolean caseCatchBlock(CatchBlock catchBlock1) {
            CatchBlock catchBlock2 = (CatchBlock)SimilaritySwitch.this.compareElement;
            OrdinaryParameter catchedException1 = catchBlock1.getParameter();
            OrdinaryParameter catchedException2 = catchBlock2.getParameter();
            Boolean exceptionSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)catchedException1, (EObject)catchedException2);
            if (exceptionSimilarity == Boolean.FALSE) {
                return exceptionSimilarity;
            }
            return Boolean.TRUE;
        }

        public Boolean caseConditional(Conditional conditional1) {
            Conditional conditional2 = (Conditional)SimilaritySwitch.this.compareElement;
            Expression expression1 = conditional1.getCondition();
            Expression expression2 = conditional2.getCondition();
            Boolean expressionSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)expression1, (EObject)expression2);
            if (expressionSimilarity == Boolean.FALSE) {
                return expressionSimilarity;
            }
            return Boolean.TRUE;
        }

        public Boolean caseJump(Jump jump1) {
            Jump jump2 = (Jump)SimilaritySwitch.this.compareElement;
            Boolean similarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)jump1.getTarget(), (EObject)jump2.getTarget());
            if (similarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean caseJumpLabel(JumpLabel label1) {
            JumpLabel label2 = (JumpLabel)SimilaritySwitch.this.compareElement;
            String name1 = Strings.nullToEmpty((String)label1.getName());
            String name2 = Strings.nullToEmpty((String)label2.getName());
            return name1.equals(name2);
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.TRUE;
        }

        private boolean differentPredecessor(Statement statement1, Statement statement2) {
            Statement pred1 = this.getPredecessor(statement1);
            Statement pred2 = this.getPredecessor(statement2);
            Boolean similarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)pred1, (EObject)pred2, false);
            return similarity == Boolean.FALSE;
        }

        private boolean differentSuccessor(Statement statement1, Statement statement2) {
            Statement pred1 = this.getSuccessor(statement1);
            Statement pred2 = this.getSuccessor(statement2);
            Boolean similarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)pred1, (EObject)pred2, false);
            return similarity == Boolean.FALSE;
        }

        private Statement getPredecessor(Statement statement) {
            int pos = JaMoPPElementUtil.getPositionInContainer((Statement)statement);
            if (pos > 0) {
                StatementListContainer container = (StatementListContainer)statement.eContainer();
                return (Statement)container.getStatements().get(pos - 1);
            }
            return null;
        }

        private Statement getSuccessor(Statement statement) {
            StatementListContainer container;
            int pos = JaMoPPElementUtil.getPositionInContainer((Statement)statement);
            if (pos != -1 && (container = (StatementListContainer)statement.eContainer()).getStatements().size() > pos + 1) {
                return (Statement)container.getStatements().get(pos + 1);
            }
            return null;
        }
    }

    private class TypesSimilaritySwitch
    extends TypesSwitch<Boolean> {
        private TypesSimilaritySwitch() {
        }

        public Boolean caseClassifierReference(ClassifierReference ref1) {
            ClassifierReference ref2 = (ClassifierReference)SimilaritySwitch.this.compareElement;
            Boolean targetSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)ref1.getTarget(), (EObject)ref2.getTarget());
            if (targetSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean caseTypeReference(TypeReference ref1) {
            TypeReference ref2 = (TypeReference)SimilaritySwitch.this.compareElement;
            Boolean targetSimilarity = SimilaritySwitch.this.similarityChecker.isSimilar((EObject)ref1.getTarget(), (EObject)ref2.getTarget());
            if (targetSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean caseNamespaceClassifierReference(NamespaceClassifierReference ref1) {
            String namespace2;
            NamespaceClassifierReference ref2 = (NamespaceClassifierReference)SimilaritySwitch.this.compareElement;
            String namespace1 = Strings.nullToEmpty((String)ref1.getNamespacesAsString());
            if (!namespace1.equals(namespace2 = Strings.nullToEmpty((String)ref2.getNamespacesAsString()))) {
                return Boolean.FALSE;
            }
            ClassifierReference pureRef1 = ref1.getPureClassifierReference();
            ClassifierReference pureRef2 = ref2.getPureClassifierReference();
            return SimilaritySwitch.this.similarityChecker.isSimilar((EObject)pureRef1, (EObject)pureRef2);
        }

        public Boolean casePrimitiveType(PrimitiveType type) {
            return Boolean.TRUE;
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.TRUE;
        }
    }

    private class VariablesSimilaritySwitch
    extends VariablesSwitch<Boolean> {
        private VariablesSimilaritySwitch() {
        }

        public Boolean caseVariable(Variable var1) {
            Variable var2 = (Variable)SimilaritySwitch.this.compareElement;
            if (!var1.getName().equals(var2.getName())) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean caseAdditionalLocalVariable(AdditionalLocalVariable var1) {
            String name2;
            AdditionalLocalVariable var2 = (AdditionalLocalVariable)SimilaritySwitch.this.compareElement;
            String name1 = Strings.nullToEmpty((String)var1.getName());
            if (!name1.equals(name2 = Strings.nullToEmpty((String)var2.getName()))) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
    }
}

