/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.extraction.cache;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.emftext.language.java.JavaClasspath;
import org.emftext.language.java.JavaPackage;
import org.emftext.language.java.resource.JavaSourceOrClassFileResourceFactoryImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.splevo.commons.emf.SPLevoResourceSet;
import org.splevo.jamopp.extraction.JaMoPPSoftwareModelExtractor;
import org.splevo.jamopp.extraction.cache.ReferenceCache;
import org.splevo.jamopp.extraction.resource.JavaSourceOrClassFileResourceCachingFactoryImpl;

public class ReferenceCacheTest {
    private TemporaryFolder folder = null;

    @BeforeClass
    public static void setUpBefore() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
    }

    @Before
    public void setUp() throws IOException {
        this.folder = new TemporaryFolder();
        this.folder.create();
    }

    @After
    public void tearDown() {
        this.folder.delete();
    }

    @Test
    public void testResolve() throws IOException {
        File cacheDir = this.folder.newFolder("cacheDir");
        ArrayList cacheFileDirs = Lists.newArrayList((Object[])new String[]{cacheDir.getAbsolutePath()});
        String resourcePath = new File("testcode/cache/basic/CalculatorSqrt.java").getCanonicalPath();
        String jarPath = "testcode/cache/basic/lib/jscience.jar";
        String jarPathAbsolute = new File(jarPath).getAbsolutePath();
        ArrayList jarPaths = Lists.newArrayList((Object[])new String[]{jarPathAbsolute});
        ResourceSet rs = this.prepareResourceSetAsDoneByExtractor(cacheFileDirs, jarPaths);
        ReferenceCache referenceCache = this.loadCache(rs, resourcePath);
        referenceCache.save();
        ResourceSet resourceSet = this.initNewResourceSet(cacheFileDirs);
        ReferenceCache referenceCacheNew = this.getReferenceCache(resourceSet);
        Resource resource = resourceSet.getResource(URI.createFileURI((String)resourcePath), true);
        referenceCacheNew.resolve(resource);
        int uncachedReferences = referenceCacheNew.getNotResolvedFromCacheCounterReference();
        Assert.assertThat((String)"No cache file created", (Object)cacheDir.listFiles().length, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Not all references were resolved by the cache", (Object)uncachedReferences, (Matcher)CoreMatchers.is((Object)0));
    }

    private ReferenceCache loadCache(ResourceSet rs, String resourcePath) {
        ReferenceCache referenceCache = this.getReferenceCache(rs);
        Resource resource = rs.getResource(URI.createFileURI((String)resourcePath), true);
        referenceCache.resolve(resource);
        return referenceCache;
    }

    private ResourceSet prepareResourceSetAsDoneByExtractor(List<String> cacheFileDirs, List<String> jarPaths) {
        SPLevoResourceSet rs = new SPLevoResourceSet();
        Map options = rs.getLoadOptions();
        options.put("OPTION_USE_LOCAL_CLASSPATH", Boolean.TRUE);
        options.put("OPTION_REGISTER_STD_LIB", Boolean.TRUE);
        options.put("DISABLE_LAYOUT_INFORMATION_RECORDING", Boolean.TRUE);
        options.put("DISABLE_LOCATION_MAP", Boolean.TRUE);
        JavaSourceOrClassFileResourceFactoryImpl originalFactory = new JavaSourceOrClassFileResourceFactoryImpl();
        EPackage.Registry.INSTANCE.put((Object)"http://www.emftext.org/java", (Object)JavaPackage.eINSTANCE);
        JavaClasspath javaClasspath = JavaClasspath.get((ResourceSet)rs);
        Map factoryMap = rs.getResourceFactoryRegistry().getExtensionToFactoryMap();
        factoryMap.put("java", new JavaSourceOrClassFileResourceCachingFactoryImpl((Resource.Factory)originalFactory, cacheFileDirs, javaClasspath, jarPaths));
        return rs;
    }

    private ReferenceCache getReferenceCache(ResourceSet resourceSet) {
        Map factoryMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        JavaSourceOrClassFileResourceCachingFactoryImpl factory = (JavaSourceOrClassFileResourceCachingFactoryImpl)factoryMap.get("java");
        ReferenceCache referenceCache = factory.getReferenceCache();
        return referenceCache;
    }

    private ResourceSet initNewResourceSet(List<String> cacheFileDirs) {
        SPLevoResourceSet resourceSet = new SPLevoResourceSet();
        JaMoPPSoftwareModelExtractor extractor = new JaMoPPSoftwareModelExtractor();
        extractor.prepareResourceSet((ResourceSet)resourceSet, cacheFileDirs, false);
        return resourceSet;
    }
}

