/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.extraction.resource;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.emftext.language.java.JavaClasspath;
import org.splevo.jamopp.extraction.cache.ReferenceCache;
import org.splevo.jamopp.extraction.resource.JavaSourceOrClassFileCachingResource;

public class JavaSourceOrClassFileResourceCachingFactoryImpl
implements Resource.Factory {
    private final Resource.Factory factory;
    private ReferenceCache referenceCache = null;

    public JavaSourceOrClassFileResourceCachingFactoryImpl(Resource.Factory factory, List<String> cacheDirectories, JavaClasspath javaClasspath) {
        this(factory, cacheDirectories, javaClasspath, null);
    }

    public JavaSourceOrClassFileResourceCachingFactoryImpl(Resource.Factory factory, List<String> cacheDirectories, JavaClasspath javaClasspath, List<String> jarPaths) {
        this.factory = factory;
        ArrayList jarPathsForReferenceCache = jarPaths;
        if (jarPaths == null) {
            jarPathsForReferenceCache = Lists.newArrayList();
        }
        this.referenceCache = new ReferenceCache(cacheDirectories, javaClasspath, jarPathsForReferenceCache);
    }

    public Resource createResource(URI uri) {
        if (uri.isFile() || uri.isPlatform()) {
            return new JavaSourceOrClassFileCachingResource(uri, this.referenceCache);
        }
        return this.factory.createResource(uri);
    }

    public ReferenceCache getReferenceCache() {
        return this.referenceCache;
    }
}

