/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.refactoring.tests;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.emftext.commons.layout.LayoutInformation;
import org.emftext.language.java.classifiers.ConcreteClassifier;
import org.emftext.language.java.commons.Commentable;
import org.emftext.language.java.containers.CompilationUnit;
import org.emftext.language.java.members.Method;
import org.emftext.language.java.modifiers.Modifier;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.extraction.SoftwareModelExtractionException;
import org.splevo.jamopp.extraction.JaMoPPSoftwareModelExtractor;
import org.splevo.jamopp.refactoring.util.RefactoringUtil;
import org.splevo.jamopp.vpm.software.CommentableSoftwareElement;
import org.splevo.jamopp.vpm.software.softwareFactory;

public class RefactoringUtilTest {
    @BeforeClass
    public static void init() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
    }

    @Test
    public void testRemoveCommentableSoftwareElementReferenceWithTrailingLineBreak() throws Exception {
        CompilationUnit cu = RefactoringUtilTest.loadTestCompilationUnit("commentableSoftwareElements");
        Modifier m = (Modifier)((ConcreteClassifier)cu.getClassifiers().get(0)).getModifiers().get(0);
        CommentableSoftwareElement cse = softwareFactory.eINSTANCE.createCommentableSoftwareElement();
        cse.setCompilationUnit(cu);
        cse.setType(CompilationUnit.class);
        cse.setId("UNIQUE_ID_10");
        String comment = RefactoringUtilTest.getHiddenTokenText((Commentable)m);
        Assert.assertThat((Object)comment, (Matcher)IsEqual.equalTo((Object)" /* SPLEVO_REF UNIQUE_ID_10 */\n"));
        RefactoringUtil.removeCommentableSoftwareElementReference((CommentableSoftwareElement)cse);
        Assert.assertThat((Object)RefactoringUtilTest.getHiddenTokenText((Commentable)m), (Matcher)IsEqual.equalTo((Object)""));
    }

    @Test
    public void testRemoveCommentableSoftwareElementReferenceWithLeadingAndTrailingLineBreak() throws Exception {
        CompilationUnit cu = RefactoringUtilTest.loadTestCompilationUnit("commentableSoftwareElements");
        Modifier m = (Modifier)((Method)((ConcreteClassifier)cu.getClassifiers().get(0)).getMethods().get(0)).getModifiers().get(0);
        CommentableSoftwareElement cse = softwareFactory.eINSTANCE.createCommentableSoftwareElement();
        cse.setCompilationUnit(cu);
        cse.setType(Method.class);
        cse.setId("UNIQUE_ID_50");
        String comment = RefactoringUtilTest.getHiddenTokenText((Commentable)m);
        Assert.assertThat((Object)comment, (Matcher)IsEqual.equalTo((Object)"\n    \n    /* SPLEVO_REF UNIQUE_ID_50 */\n    /**\n     * This method does nothing. \n     */\n    "));
        RefactoringUtil.removeCommentableSoftwareElementReference((CommentableSoftwareElement)cse);
        Assert.assertThat((Object)RefactoringUtilTest.getHiddenTokenText((Commentable)m), (Matcher)IsEqual.equalTo((Object)"\n    \n    /**\n     * This method does nothing. \n     */\n    "));
    }

    @Test
    public void testRemoveCommentableSoftwareElementReferenceWithLeadingLineBreak() throws Exception {
        CompilationUnit cu = RefactoringUtilTest.loadTestCompilationUnit("commentableSoftwareElements");
        Modifier m = (Modifier)((Method)((ConcreteClassifier)cu.getClassifiers().get(0)).getMethods().get(1)).getModifiers().get(0);
        CommentableSoftwareElement cse = softwareFactory.eINSTANCE.createCommentableSoftwareElement();
        cse.setCompilationUnit(cu);
        cse.setType(Method.class);
        cse.setId("UNIQUE_ID_100");
        String comment = RefactoringUtilTest.getHiddenTokenText((Commentable)m);
        Assert.assertThat((Object)comment, (Matcher)IsEqual.equalTo((Object)"\n    \n    /* SPLEVO_REF UNIQUE_ID_100 */"));
        RefactoringUtil.removeCommentableSoftwareElementReference((CommentableSoftwareElement)cse);
        Assert.assertThat((Object)RefactoringUtilTest.getHiddenTokenText((Commentable)m), (Matcher)IsEqual.equalTo((Object)"\n    \n    "));
    }

    private static String getHiddenTokenText(Commentable commentable) {
        return RefactoringUtilTest.getHiddenTokenText(commentable, true);
    }

    private static String getHiddenTokenText(Commentable commentable, boolean normalizeLineEndings) {
        LayoutInformation layoutInformation = (LayoutInformation)Iterables.getFirst((Iterable)commentable.getLayoutInformations(), null);
        String hiddenTokenText = layoutInformation.getHiddenTokenText();
        if (!normalizeLineEndings) {
            return hiddenTokenText;
        }
        return hiddenTokenText.replaceAll("\\r\\n", "\n");
    }

    private static CompilationUnit loadTestCompilationUnit(String folderName) throws SoftwareModelExtractionException {
        JaMoPPSoftwareModelExtractor extractor = new JaMoPPSoftwareModelExtractor();
        ResourceSet rs = extractor.extractSoftwareModel((List)Lists.newArrayList((Object[])new String[]{"testcode/" + folderName}), (IProgressMonitor)new NullProgressMonitor(), null, true);
        return (CompilationUnit)((Resource)rs.getResources().get(0)).getContents().get(0);
    }
}

