/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.refactoring.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.Switch;
import org.emftext.commons.layout.LayoutInformation;
import org.emftext.language.java.arrays.ArrayDimension;
import org.emftext.language.java.arrays.ArrayInitializer;
import org.emftext.language.java.arrays.ArrayInstantiationByValues;
import org.emftext.language.java.arrays.ArrayInstantiationByValuesTyped;
import org.emftext.language.java.arrays.ArraysFactory;
import org.emftext.language.java.classifiers.Class;
import org.emftext.language.java.classifiers.ConcreteClassifier;
import org.emftext.language.java.classifiers.Enumeration;
import org.emftext.language.java.classifiers.Interface;
import org.emftext.language.java.commons.Commentable;
import org.emftext.language.java.containers.CompilationUnit;
import org.emftext.language.java.containers.util.ContainersSwitch;
import org.emftext.language.java.expressions.AssignmentExpression;
import org.emftext.language.java.expressions.AssignmentExpressionChild;
import org.emftext.language.java.expressions.Expression;
import org.emftext.language.java.expressions.ExpressionsFactory;
import org.emftext.language.java.imports.Import;
import org.emftext.language.java.instantiations.ExplicitConstructorCall;
import org.emftext.language.java.literals.BooleanLiteral;
import org.emftext.language.java.literals.CharacterLiteral;
import org.emftext.language.java.literals.DecimalDoubleLiteral;
import org.emftext.language.java.literals.DecimalFloatLiteral;
import org.emftext.language.java.literals.DecimalIntegerLiteral;
import org.emftext.language.java.literals.DecimalLongLiteral;
import org.emftext.language.java.literals.Literal;
import org.emftext.language.java.literals.LiteralsFactory;
import org.emftext.language.java.members.ClassMethod;
import org.emftext.language.java.members.Constructor;
import org.emftext.language.java.members.Field;
import org.emftext.language.java.members.Member;
import org.emftext.language.java.members.MemberContainer;
import org.emftext.language.java.members.Method;
import org.emftext.language.java.members.util.MembersSwitch;
import org.emftext.language.java.modifiers.AnnotableAndModifiable;
import org.emftext.language.java.modifiers.Final;
import org.emftext.language.java.modifiers.Modifier;
import org.emftext.language.java.operators.AssignmentOperator;
import org.emftext.language.java.operators.OperatorsFactory;
import org.emftext.language.java.parameters.Parameter;
import org.emftext.language.java.references.IdentifierReference;
import org.emftext.language.java.references.ReferenceableElement;
import org.emftext.language.java.references.ReferencesFactory;
import org.emftext.language.java.statements.ExpressionStatement;
import org.emftext.language.java.statements.LocalVariableStatement;
import org.emftext.language.java.statements.Return;
import org.emftext.language.java.statements.Statement;
import org.emftext.language.java.statements.StatementListContainer;
import org.emftext.language.java.statements.StatementsFactory;
import org.emftext.language.java.types.Boolean;
import org.emftext.language.java.types.Char;
import org.emftext.language.java.types.Double;
import org.emftext.language.java.types.Float;
import org.emftext.language.java.types.Int;
import org.emftext.language.java.types.Long;
import org.emftext.language.java.types.Short;
import org.emftext.language.java.types.Type;
import org.emftext.language.java.types.TypeReference;
import org.emftext.language.java.types.Void;
import org.emftext.language.java.variables.LocalVariable;
import org.splevo.jamopp.diffing.similarity.SimilarityChecker;
import org.splevo.jamopp.util.JaMoPPElementUtil;
import org.splevo.jamopp.vpm.software.CommentableSoftwareElement;
import org.splevo.jamopp.vpm.software.JaMoPPJavaSoftwareElement;
import org.splevo.jamopp.vpm.software.impl.CommentableSoftwareElementImpl;
import org.splevo.jamopp.vpm.software.softwareFactory;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public final class RefactoringUtil {
    private static SimilarityChecker similarityChecker;

    static {
        LinkedHashMap config = Maps.newLinkedHashMap();
        similarityChecker = new SimilarityChecker(config, config, config);
    }

    private RefactoringUtil() {
    }

    public static void addReturnStatement(ClassMethod method) {
        if (method.getStatements().get(method.getStatements().size() - 1) instanceof Return) {
            return;
        }
        Return returnStatement = StatementsFactory.eINSTANCE.createReturn();
        Type methodReturnType = method.getTypeReference().getTarget();
        Literal returnValue = RefactoringUtil.getDefaultValueForType(methodReturnType);
        returnStatement.setReturnValue((Expression)returnValue);
        method.getStatements().add((Object)returnStatement);
    }

    public static boolean hasLeadingVariant(VariationPoint variationPoint) {
        for (Variant variant : variationPoint.getVariants()) {
            if (!variant.getLeading().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMembersWithConflictingNames(VariationPoint variationPoint) {
        if (RefactoringUtil.hasLeadingVariant(variationPoint)) {
            return false;
        }
        Commentable jamoppElement = ((JaMoPPJavaSoftwareElement)variationPoint.getLocation()).getJamoppElement();
        for (Variant variant : variationPoint.getVariants()) {
            for (SoftwareElement se : variant.getImplementingElements()) {
                Member member = (Member)((JaMoPPJavaSoftwareElement)se).getJamoppElement();
                if (!RefactoringUtil.containsClassInterfaceOrEnumWithName(jamoppElement, member.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static void deleteVariableStatements(VariationPoint variationPoint) {
        StatementListContainer vpLocation = (StatementListContainer)((JaMoPPJavaSoftwareElement)variationPoint.getLocation()).getJamoppElement();
        for (Variant variant : variationPoint.getVariants()) {
            if (!variant.getLeading().booleanValue()) continue;
            for (SoftwareElement se : variant.getImplementingElements()) {
                Statement variantStatement = (Statement)((JaMoPPJavaSoftwareElement)se).getJamoppElement();
                vpLocation.getStatements().remove((Object)variantStatement);
            }
        }
    }

    public static void deleteVariableMembersFromLeading(VariationPoint variationPoint) {
        MemberContainer vpLocation = (MemberContainer)((JaMoPPJavaSoftwareElement)variationPoint.getLocation()).getJamoppElement();
        for (Variant variant : variationPoint.getVariants()) {
            if (!variant.getLeading().booleanValue()) continue;
            for (SoftwareElement se : variant.getImplementingElements()) {
                Member variantMember = (Member)((JaMoPPJavaSoftwareElement)se).getJamoppElement();
                vpLocation.getMembers().remove((Object)variantMember);
            }
        }
    }

    public static ExpressionStatement extractAssignment(LocalVariable variable) {
        if (variable.getInitialValue() == null) {
            return null;
        }
        IdentifierReference varRef = ReferencesFactory.eINSTANCE.createIdentifierReference();
        varRef.setTarget((ReferenceableElement)EcoreUtil.copy((EObject)variable));
        AssignmentExpression assignmentExpression = ExpressionsFactory.eINSTANCE.createAssignmentExpression();
        if (variable.getInitialValue() instanceof ArrayInstantiationByValues) {
            EList initialValues = ((ArrayInstantiationByValues)variable.getInitialValue()).getArrayInitializer().getInitialValues();
            ArrayInstantiationByValuesTyped arrayInstantiationByValuesTyped = ArraysFactory.eINSTANCE.createArrayInstantiationByValuesTyped();
            ArrayInitializer arrayInitializer = ArraysFactory.eINSTANCE.createArrayInitializer();
            arrayInitializer.getInitialValues().addAll((Collection)initialValues);
            arrayInstantiationByValuesTyped.setArrayInitializer(arrayInitializer);
            arrayInstantiationByValuesTyped.setTypeReference((TypeReference)EcoreUtil.copy((EObject)variable.getTypeReference()));
            ArrayDimension arrayDimension = ArraysFactory.eINSTANCE.createArrayDimension();
            arrayInstantiationByValuesTyped.getArrayDimensionsBefore().add((Object)arrayDimension);
            assignmentExpression.setValue((Expression)arrayInstantiationByValuesTyped);
        } else {
            assignmentExpression.setValue(variable.getInitialValue());
        }
        assignmentExpression.setAssignmentOperator((AssignmentOperator)OperatorsFactory.eINSTANCE.createAssignment());
        assignmentExpression.setChild((AssignmentExpressionChild)varRef);
        ExpressionStatement expressionStatement = StatementsFactory.eINSTANCE.createExpressionStatement();
        expressionStatement.setExpression((Expression)assignmentExpression);
        Type variableType = variable.getTypeReference().getTarget();
        Literal defaultValue = RefactoringUtil.getDefaultValueForType(variableType);
        variable.setInitialValue((Expression)defaultValue);
        return expressionStatement;
    }

    public static boolean isReferencedByPostdecessor(LocalVariableStatement localVariableStatement, int offset) {
        int toIndex;
        LocalVariable variable = localVariableStatement.getVariable();
        StatementListContainer container = (StatementListContainer)localVariableStatement.eContainer();
        EList containerStatements = container.getStatements();
        int index = containerStatements.indexOf((Object)localVariableStatement);
        int fromIndex = index + offset;
        if (fromIndex >= (toIndex = containerStatements.size())) {
            return false;
        }
        List postdecessors = containerStatements.subList(fromIndex, toIndex);
        for (Statement postdecessor : postdecessors) {
            if (!RefactoringUtil.hasReferenceTo(postdecessor, variable)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasReferenceTo(Statement toBeChecked, LocalVariable variable) {
        TreeIterator allContents = EcoreUtil.getAllContents((EObject)toBeChecked, (boolean)true);
        while (allContents.hasNext()) {
            EObject next = (EObject)allContents.next();
            if (!(next instanceof IdentifierReference) || !RefactoringUtil.areEqual((Commentable)((IdentifierReference)next).getTarget(), (Commentable)variable).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static void initializeAndRemoveFinalForReferencedVariables(EObject eObject) {
        TreeIterator contents = EcoreUtil.getAllContents((EObject)eObject, (boolean)true);
        while (contents.hasNext()) {
            EObject child = (EObject)contents.next();
            for (EObject crossReference : child.eCrossReferences()) {
                LocalVariable variable;
                if (crossReference instanceof AnnotableAndModifiable) {
                    RefactoringUtil.removeFinalIfApplicable((AnnotableAndModifiable)crossReference);
                }
                if (!(crossReference instanceof LocalVariable) || (variable = (LocalVariable)crossReference).getInitialValue() != null) continue;
                Type variableType = variable.getTypeReference().getTarget();
                variable.setInitialValue((Expression)RefactoringUtil.getDefaultValueForType(variableType));
            }
            RefactoringUtil.initializeAndRemoveFinalForReferencedVariables(child);
        }
    }

    public static <T> boolean allImplementingElementsOfType(VariationPoint variationPoint, java.lang.Class<T> c) {
        for (Variant variant : variationPoint.getVariants()) {
            for (SoftwareElement se : variant.getImplementingElements()) {
                Commentable commentable = ((JaMoPPJavaSoftwareElement)se).getJamoppElement();
                if (c.isInstance(commentable)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsImport(CompilationUnit cu, Import i) {
        for (Import currentI : cu.getImports()) {
            if (!RefactoringUtil.areEqual((Commentable)currentI, (Commentable)i).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static void addCommentBefore(Commentable vpLocation, String comment) {
        LayoutInformation layoutInformation = RefactoringUtil.getFirstLayoutInformation(vpLocation);
        if (layoutInformation == null) {
            return;
        }
        String finalComment = layoutInformation.getHiddenTokenText();
        finalComment = finalComment.length() == 0 ? "/* " + comment + " */\n" : "\n/* " + comment + " */\n" + finalComment;
        layoutInformation.setHiddenTokenText(finalComment);
    }

    public static boolean removeFinalIfApplicable(AnnotableAndModifiable modifieable) {
        for (Modifier modifier : modifieable.getModifiers()) {
            if (!(modifier instanceof Final)) continue;
            modifieable.removeModifier(Final.class);
            return true;
        }
        return false;
    }

    public static boolean hasConstructorWithEqualParameters(Class c, Constructor constructor) {
        for (Constructor vpConstructor : c.getConstructors()) {
            EList givenParams;
            EList currentConstructorParams = vpConstructor.getParameters();
            boolean haveEqualSetOfParameters = RefactoringUtil.haveEqualSetOfParameters((EList<Parameter>)currentConstructorParams, (EList<Parameter>)(givenParams = constructor.getParameters()));
            if (!haveEqualSetOfParameters) continue;
            return true;
        }
        return false;
    }

    private static boolean haveEqualSetOfParameters(EList<Parameter> params1, EList<Parameter> params2) {
        if (params1.size() != params2.size()) {
            return false;
        }
        int i = 0;
        while (i < params1.size()) {
            Type target2;
            Type target1 = ((Parameter)params1.get(i)).getTypeReference().getTarget();
            if (!RefactoringUtil.areEqual((Commentable)target1, (Commentable)(target2 = ((Parameter)params2.get(i)).getTypeReference().getTarget())).booleanValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean hasMethodWithEqualNameAndParameters(MemberContainer memberContainer, Method method) {
        for (Method vpMethod : memberContainer.getMethods()) {
            if (!method.getName().equals(vpMethod.getName()) || !RefactoringUtil.haveEqualSetOfParameters((EList<Parameter>)method.getParameters(), (EList<Parameter>)vpMethod.getParameters())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasConflictingLocalVariables(VariationPoint variationPoint) {
        HashMap<String, Type> namedVariables = new HashMap<String, Type>();
        for (Variant variant : variationPoint.getVariants()) {
            for (SoftwareElement se : variant.getImplementingElements()) {
                int offset;
                LocalVariableStatement localVarStatement;
                Commentable currentElement = ((JaMoPPJavaSoftwareElement)se).getJamoppElement();
                if (!(currentElement instanceof LocalVariableStatement) || !RefactoringUtil.isReferencedByPostdecessor(localVarStatement = (LocalVariableStatement)currentElement, offset = variant.getImplementingElements().size() - variant.getImplementingElements().indexOf((Object)se))) continue;
                LocalVariable variable = localVarStatement.getVariable();
                Type variableType = variable.getTypeReference().getTarget();
                Type oldValue = namedVariables.put(variable.getName(), variableType);
                if (oldValue == null || variableType == null || RefactoringUtil.areEqual((Commentable)oldValue, (Commentable)variableType).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasConflictingFields(VariationPoint variationPoint) {
        HashMap<String, Type> namedVariables = new HashMap<String, Type>();
        for (Variant variant : variationPoint.getVariants()) {
            for (SoftwareElement se : variant.getImplementingElements()) {
                Commentable currentElement = ((JaMoPPJavaSoftwareElement)se).getJamoppElement();
                if (!(currentElement instanceof Field)) continue;
                Field field = (Field)currentElement;
                Type fieldType = field.getTypeReference().getTarget();
                Type oldValue = namedVariables.put(field.getName(), fieldType);
                if (oldValue == null || oldValue.getClass().equals(fieldType.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasConflictingMethods(VariationPoint variationPoint) {
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Variant variant : variationPoint.getVariants()) {
            methods.addAll(RefactoringUtil.getImplementingElements(variant, Method.class));
        }
        TypeReference retType = null;
        for (Method method : methods) {
            if (retType == null) {
                retType = method.getTypeReference();
                continue;
            }
            if (EcoreUtil.equals((EObject)method.getTypeReference(), (EObject)retType)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasConstructorCalls(VariationPoint variationPoint) {
        for (Variant variant : variationPoint.getVariants()) {
            List<Statement> implementingElements = RefactoringUtil.getImplementingElements(variant, Statement.class);
            for (Statement statement : implementingElements) {
                Expression expression;
                if (!(statement instanceof ExpressionStatement) || !((expression = ((ExpressionStatement)statement).getExpression()) instanceof ExplicitConstructorCall)) continue;
                return true;
            }
        }
        return false;
    }

    public static java.lang.Boolean areEqual(Commentable c1, Commentable c2) {
        return similarityChecker.isSimilar((EObject)c1, (EObject)c2, false);
    }

    public static Literal getDefaultValueForType(Type type) {
        if (type instanceof Void) {
            return null;
        }
        if (type instanceof Boolean) {
            BooleanLiteral literal = LiteralsFactory.eINSTANCE.createBooleanLiteral();
            literal.setValue(false);
            return literal;
        }
        if (type instanceof Char) {
            CharacterLiteral literal = LiteralsFactory.eINSTANCE.createCharacterLiteral();
            literal.setValue('\u0000');
            return literal;
        }
        if (type instanceof Double) {
            DecimalDoubleLiteral literal = LiteralsFactory.eINSTANCE.createDecimalDoubleLiteral();
            literal.setDecimalValue(0.0);
            return literal;
        }
        if (type instanceof Float) {
            DecimalFloatLiteral literal = LiteralsFactory.eINSTANCE.createDecimalFloatLiteral();
            literal.setDecimalValue(0.0f);
            return literal;
        }
        if (type instanceof Int) {
            DecimalIntegerLiteral literal = LiteralsFactory.eINSTANCE.createDecimalIntegerLiteral();
            literal.setDecimalValue(BigInteger.valueOf(0L));
            return literal;
        }
        if (type instanceof Long) {
            DecimalLongLiteral literal = LiteralsFactory.eINSTANCE.createDecimalLongLiteral();
            literal.setDecimalValue(BigInteger.valueOf(0L));
            return literal;
        }
        if (type instanceof Short) {
            DecimalIntegerLiteral literal = LiteralsFactory.eINSTANCE.createDecimalIntegerLiteral();
            literal.setDecimalValue(BigInteger.valueOf(0L));
            return literal;
        }
        return LiteralsFactory.eINSTANCE.createNullLiteral();
    }

    private static <T extends Commentable> List<T> getImplementingElements(Variant variant, java.lang.Class<T> type) {
        LinkedList<Commentable> elements = new LinkedList<Commentable>();
        for (SoftwareElement se : variant.getImplementingElements()) {
            Commentable element = ((JaMoPPJavaSoftwareElement)se).getJamoppElement();
            elements.add(element);
        }
        return elements;
    }

    private static LayoutInformation getFirstLayoutInformation(Commentable commentable) {
        List<LayoutInformation> layoutInfos = RefactoringUtil.getRecursiveLayoutInfos(commentable);
        if (layoutInfos.isEmpty()) {
            return null;
        }
        return layoutInfos.get(0);
    }

    private static List<LayoutInformation> getRecursiveLayoutInfos(Commentable commentable) {
        ArrayList<LayoutInformation> layoutInfos = new ArrayList<LayoutInformation>();
        ArrayList<Commentable> objects = new ArrayList<Commentable>();
        objects.add(commentable);
        TreeIterator allContents = EcoreUtil.getAllContents(objects);
        while (allContents.hasNext()) {
            EObject next = (EObject)allContents.next();
            if (!(next instanceof Commentable)) continue;
            Commentable childCommentable = (Commentable)next;
            layoutInfos.addAll((Collection<LayoutInformation>)childCommentable.getLayoutInformations());
        }
        layoutInfos.addAll((Collection<LayoutInformation>)commentable.getLayoutInformations());
        Collections.sort(layoutInfos, new Comparator<LayoutInformation>(){

            @Override
            public int compare(LayoutInformation o1, LayoutInformation o2) {
                return o1.getStartOffset() - o2.getStartOffset();
            }
        });
        return layoutInfos;
    }

    public static boolean containsClassInterfaceOrEnumWithName(Commentable container, String name) {
        ContainerHasConflictingNameSwitch switcher = new ContainerHasConflictingNameSwitch(name);
        return (java.lang.Boolean)switcher.doSwitch((EObject)container);
    }

    public static void resolveVPsWithSameLocation(VariationPoint variationPoint) {
        VariationPointModel vpm = variationPoint.getGroup().getModel();
        Commentable vpLocation = ((JaMoPPJavaSoftwareElement)variationPoint.getLocation()).getJamoppElement();
        for (VariationPointGroup vpg : vpm.getVariationPointGroups()) {
            for (VariationPoint vp : vpg.getVariationPoints()) {
                Commentable currentVPLocation = ((JaMoPPJavaSoftwareElement)vp.getLocation()).getJamoppElement();
                if (vpLocation != currentVPLocation && !JaMoPPElementUtil.isParentOf((Commentable)vpLocation, (Commentable)currentVPLocation)) continue;
                for (Variant v : vp.getVariants()) {
                    if (!v.getLeading().booleanValue()) continue;
                    for (SoftwareElement se : v.getImplementingElements()) {
                        EcoreUtil.resolveAll((EObject)se);
                    }
                }
            }
        }
    }

    public static String addCommentableSoftwareElementReference(Commentable element) {
        String elementID = EcoreUtil.generateUUID();
        String commentText = CommentableSoftwareElementImpl.buildReferencingCommentText((String)elementID);
        RefactoringUtil.addCommentBefore(element, commentText);
        return elementID;
    }

    public static CommentableSoftwareElement createCommentableSoftwareElement(Commentable referencedElement, String id) {
        CommentableSoftwareElement commentable = softwareFactory.eINSTANCE.createCommentableSoftwareElement();
        commentable.setCompilationUnit(referencedElement.getContainingCompilationUnit());
        commentable.setId(id);
        commentable.setType(referencedElement.getClass());
        return commentable;
    }

    private static class ContainerHasConflictingNameSwitch
    extends ComposedSwitch<java.lang.Boolean> {
        protected final String possibleConflictingName;

        public ContainerHasConflictingNameSwitch(String possibleConflictingName) {
            this.possibleConflictingName = possibleConflictingName;
            this.addSwitch((Switch)new ContainerElementHasConflictingNameSwitch());
            this.addSwitch((Switch)new MemberElementHasConflictingNameSwitch());
        }

        public java.lang.Boolean defaultCase(EObject eObject) {
            return false;
        }

        private static boolean containsClassInterfaceOrEnumWithName(Iterable<Member> members, final String name) {
            Iterable filteredMembers = Iterables.concat((Iterable)Iterables.filter(members, Class.class), (Iterable)Iterables.filter(members, Interface.class), (Iterable)Iterables.filter(members, Enumeration.class));
            return Iterables.any((Iterable)filteredMembers, (Predicate)new Predicate<ConcreteClassifier>(){

                public boolean apply(ConcreteClassifier input) {
                    return input.getName().equals(name);
                }
            });
        }

        private class ContainerElementHasConflictingNameSwitch
        extends ContainersSwitch<java.lang.Boolean> {
            private ContainerElementHasConflictingNameSwitch() {
            }

            public java.lang.Boolean caseCompilationUnit(CompilationUnit object) {
                return ContainerHasConflictingNameSwitch.containsClassInterfaceOrEnumWithName(Iterables.filter((Iterable)object.getClassifiers(), Member.class), ContainerHasConflictingNameSwitch.this.possibleConflictingName);
            }
        }

        private class MemberElementHasConflictingNameSwitch
        extends MembersSwitch<java.lang.Boolean> {
            private MemberElementHasConflictingNameSwitch() {
            }

            public java.lang.Boolean caseMemberContainer(MemberContainer object) {
                return ContainerHasConflictingNameSwitch.containsClassInterfaceOrEnumWithName((Iterable)object.getMembers(), ContainerHasConflictingNameSwitch.this.possibleConflictingName);
            }
        }
    }
}

