/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.refactoring;

import com.google.common.collect.Lists;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.splevo.refactoring.TodoTagCustomizer;

public class JaMoPPTodoTagCustomizer
implements TodoTagCustomizer {
    private static final String JDT_PROPERTIES_QUALIFIER = "org.eclipse.jdt.core";
    private static final String TODO_TASK_TAG = "SPLEVO_REFACTORING";
    private static final String TODO_TASK_TAG_PROPERTY_QUALIFIER = "org.eclipse.jdt.core.compiler.taskTags";
    private static final String TODO_TASK_PRIORITY = "NORMAL";
    private static final String TODO_TASK_PRIORITY_PROPERTY_QUALIFIER = "org.eclipse.jdt.core.compiler.taskPriorities";
    private static final Logger LOGGER = Logger.getLogger(JaMoPPTodoTagCustomizer.class);

    public static String getTodoTaskTag() {
        return TODO_TASK_TAG;
    }

    public void adjustTodoTags() {
        ScopedPreferenceStore jdt = new ScopedPreferenceStore(InstanceScope.INSTANCE, JDT_PROPERTIES_QUALIFIER);
        String taskTags = jdt.getString(TODO_TASK_TAG_PROPERTY_QUALIFIER);
        if (taskTags.contains(TODO_TASK_TAG)) {
            return;
        }
        taskTags = String.valueOf(taskTags) + "," + TODO_TASK_TAG;
        jdt.putValue(TODO_TASK_TAG_PROPERTY_QUALIFIER, taskTags);
        String taskPriorities = jdt.getString(TODO_TASK_PRIORITY_PROPERTY_QUALIFIER);
        taskPriorities = String.valueOf(taskPriorities) + "," + TODO_TASK_PRIORITY;
        jdt.putValue(TODO_TASK_PRIORITY_PROPERTY_QUALIFIER, taskPriorities);
        try {
            jdt.save();
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Could not save preferences.", (Throwable)e);
        }
    }

    public Iterable<String> getTodoTags() {
        return Lists.newArrayList((Object[])new String[]{JaMoPPTodoTagCustomizer.getTodoTaskTag()});
    }
}

