/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.ui.vpexplorer.filter;

import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.emftext.language.java.commons.Commentable;
import org.splevo.jamopp.vpm.software.JaMoPPJavaSoftwareElement;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;

public abstract class AbstractJaMoPPVPFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof Variant || element instanceof Commentable || element instanceof SoftwareElement) {
            return true;
        }
        if (element instanceof VariationPoint) {
            return this.select((VariationPoint)element);
        }
        StructuredViewer sviewer = (StructuredViewer)viewer;
        ITreeContentProvider provider = (ITreeContentProvider)sviewer.getContentProvider();
        Object[] objectArray = provider.getChildren(element);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (this.select(viewer, element, child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean select(VariationPoint variationPoint) {
        if (!this.isValidLocation(variationPoint)) {
            return false;
        }
        return this.validImplementationElements(variationPoint);
    }

    private boolean validImplementationElements(VariationPoint variationPoint) {
        List<Class<?>> includeClasses = this.getImplementingElementClass();
        Class<?> excludeClass = this.getExcludeImplementingElementClass();
        for (Variant variant : variationPoint.getVariants()) {
            for (SoftwareElement implementingElement : variant.getImplementingElements()) {
                JaMoPPJavaSoftwareElement jamoppElement = (JaMoPPJavaSoftwareElement)implementingElement;
                boolean isIncludeElement = false;
                for (Class<?> includeClass : includeClasses) {
                    if (!includeClass.isAssignableFrom(jamoppElement.getJamoppElement().getClass())) continue;
                    isIncludeElement = true;
                    break;
                }
                if (isIncludeElement && (excludeClass == null || !excludeClass.isAssignableFrom(jamoppElement.getJamoppElement().getClass()))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidLocation(VariationPoint variationPoint) {
        if (!(variationPoint.getLocation() instanceof JaMoPPJavaSoftwareElement)) {
            return false;
        }
        Commentable jamoppElement = ((JaMoPPJavaSoftwareElement)variationPoint.getLocation()).getJamoppElement();
        Class<?> variationPointClass = this.getExpectedLocationClass();
        if (variationPointClass != null) {
            return variationPointClass.isAssignableFrom(jamoppElement.getClass());
        }
        return true;
    }

    protected abstract Class<?> getExpectedLocationClass();

    protected abstract List<Class<?>> getImplementingElementClass();

    protected Class<?> getExcludeImplementingElementClass() {
        return null;
    }
}

