/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.clonedchange.test;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.splevo.jamopp.vpm.analyzer.clonedchange.ClonedChangeAnalyzer;
import org.splevo.vpm.analyzer.config.AbstractVPMAnalyzerConfiguration;
import org.splevo.vpm.analyzer.config.ChoiceConfiguration;
import org.splevo.vpm.analyzer.config.NumericConfiguration;
import org.splevo.vpm.analyzer.config.VPMAnalyzerConfigurationSet;

public class ClonedChangeAnalyzerTest {
    private ClonedChangeAnalyzer analyzer;

    @Before
    public void initialize() {
        this.analyzer = new ClonedChangeAnalyzer();
    }

    @Test
    public void testAnalyzerNameSet() {
        Assert.assertThat((String)"Analyzer name", (Object)this.analyzer.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((String)"Analyzer name", (Object)this.analyzer.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)"")));
    }

    @Test
    public void testAnalyzerRelationshipLabelSet() {
        Assert.assertThat((String)"Analyzer relationship label", (Object)this.analyzer.getRelationshipLabel(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((String)"Analyzer relationship label", (Object)this.analyzer.getRelationshipLabel(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)"")));
    }

    @Test
    public void testConfigurations() {
        VPMAnalyzerConfigurationSet confSet = this.analyzer.getConfigurations();
        Assert.assertThat((String)"Analyzer configuration", (Object)confSet, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.checkMinElementThresholdConfig(confSet);
        this.checkDetectionTypeConfig(confSet);
    }

    private void checkMinElementThresholdConfig(VPMAnalyzerConfigurationSet confSet) {
        AbstractVPMAnalyzerConfiguration threshConf = confSet.getConfiguration("General Configuations", "org.splevo.jamopp.vpm.analyzer.clonedchangeINVOLVED_ELEMENT_THRESHOLD");
        Assert.assertThat((String)"MinElementThresholdConfig", (Object)threshConf, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((String)"MinElementThresholdConfig class", (Object)threshConf, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumericConfiguration.class)));
        NumericConfiguration numConf = (NumericConfiguration)threshConf;
        Assert.assertThat((String)"ThresholdConfig label", (Object)numConf.getLabel(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((String)"ThresholdConfig label", (Object)numConf.getLabel(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)"")));
        Assert.assertThat((String)"ThresholdConfig explanation", (Object)numConf.getExplanation(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((String)"ThresholdConfig explanation", (Object)numConf.getExplanation(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)"")));
        Assert.assertTrue((String)"The lower boundary is non negative", (numConf.getLowerBoundary() >= 0 ? 1 : 0) != 0);
    }

    private void checkDetectionTypeConfig(VPMAnalyzerConfigurationSet confSet) {
        AbstractVPMAnalyzerConfiguration detectionConf = confSet.getConfiguration("General Configuations", "org.splevo.jamopp.vpm.analyzer.clonedchangeDETECTION_TYPE");
        Assert.assertThat((String)"DetectionTypeConfig", (Object)detectionConf, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((String)"DetectionTypeConfig class", (Object)detectionConf, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ChoiceConfiguration.class)));
        ChoiceConfiguration choiceConf = (ChoiceConfiguration)detectionConf;
        Assert.assertThat((String)"DetectionTypeConfig label", (Object)choiceConf.getLabel(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((String)"DetectionTypeConfig label", (Object)choiceConf.getLabel(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)"")));
        Assert.assertThat((String)"DetectionTypeConfig explanation", (Object)choiceConf.getExplanation(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((String)"DetectionTypeConfig explanation", (Object)choiceConf.getExplanation(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)"")));
        Assert.assertThat((String)"DetectionTypeConfig number of choices", (Object)choiceConf.getAvailableValues().size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)0)));
    }
}

