/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.clonedchange;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.emftext.commons.layout.LayoutInformation;
import org.emftext.language.java.commons.Commentable;
import org.graphstream.graph.Node;
import org.splevo.jamopp.algorithm.clones.baxtor.CloneDetectionType;
import org.splevo.jamopp.algorithm.clones.baxtor.CloneDetector;
import org.splevo.jamopp.vpm.analyzer.clonedchange.Config;
import org.splevo.vpm.analyzer.AbstractVPMAnalyzer;
import org.splevo.vpm.analyzer.VPMAnalyzer;
import org.splevo.vpm.analyzer.VPMAnalyzerException;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.VPMEdgeDescriptor;
import org.splevo.vpm.analyzer.config.AbstractVPMAnalyzerConfiguration;
import org.splevo.vpm.analyzer.config.ChoiceConfiguration;
import org.splevo.vpm.analyzer.config.NumericConfiguration;
import org.splevo.vpm.analyzer.config.VPMAnalyzerConfigurationSet;
import org.splevo.vpm.analyzer.graph.VPMGraph;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;

public class ClonedChangeAnalyzer
extends AbstractVPMAnalyzer {
    private static final String ANALYZER_NAME = "Cloned Change Analyzer";
    private static final String RELATIONSHIP_LABEL = "ClonedChange";
    private NumericConfiguration minElementThresholdConfig = Config.createMinElementThresholdConfig();
    private ChoiceConfiguration detectionTypeConfig = Config.createDetectionTypeConfig();

    public VPMAnalyzerResult analyze(VPMGraph vpmGraph) throws VPMAnalyzerException {
        VPMAnalyzerResult result = new VPMAnalyzerResult((VPMAnalyzer)this);
        List<VPMEdgeDescriptor> edges = this.findEdgesBetweenClonedChanges(vpmGraph);
        result.getEdgeDescriptors().addAll(edges);
        return result;
    }

    private List<VPMEdgeDescriptor> findEdgesBetweenClonedChanges(VPMGraph vpmGraph) {
        CloneDetector cloneDetector = new CloneDetector(CloneDetectionType.valueOf((String)((String)this.detectionTypeConfig.getCurrentValue())));
        ArrayList<VPMEdgeDescriptor> descriptors = new ArrayList<VPMEdgeDescriptor>();
        ArrayList edgeRegistry = new ArrayList();
        int numNodes = vpmGraph.getNodeCount();
        int i = 0;
        while (i < numNodes) {
            Node node1 = vpmGraph.getNode(i);
            VariationPoint vp1 = (VariationPoint)node1.getAttribute("vp.vp", VariationPoint.class);
            EList variants1 = vp1.getVariants();
            for (Variant v1 : variants1) {
                EList elements1 = v1.getImplementingElements();
                List<Commentable> jamoppElements1 = this.buildJaMoPPElementList((EList<SoftwareElement>)elements1);
                int elementCount1 = this.countChildElements(jamoppElements1);
                if (elementCount1 < (Integer)this.minElementThresholdConfig.getCurrentValue()) continue;
                int j = i + 1;
                while (j < numNodes) {
                    String subLabel;
                    VPMEdgeDescriptor edge;
                    Node node2 = vpmGraph.getNode(j);
                    VariationPoint vp2 = (VariationPoint)node2.getAttribute("vp.vp", VariationPoint.class);
                    EList variants2 = vp2.getVariants();
                    boolean cloneDetected = false;
                    int involvedElements = 0;
                    for (Variant v2 : variants2) {
                        List<Commentable> jamoppElements2;
                        int elementCount2;
                        if (!v1.getId().equals(v2.getId())) continue;
                        EList elements2 = v2.getImplementingElements();
                        if (elements1.size() != elements2.size() || elementCount1 != (elementCount2 = this.countChildElements(jamoppElements2 = this.buildJaMoPPElementList((EList<SoftwareElement>)elements2))) || !(cloneDetected = cloneDetector.isClone(jamoppElements1, jamoppElements2))) continue;
                        involvedElements = elementCount1;
                        break;
                    }
                    if (cloneDetected && (edge = this.buildEdgeDescriptor(node1, node2, subLabel = "Clone with " + involvedElements + " elements involved", edgeRegistry)) != null) {
                        descriptors.add(edge);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return descriptors;
    }

    private int countChildElements(List<Commentable> jamoppElements1) {
        int elementCount = 0;
        for (Commentable commentable : jamoppElements1) {
            for (EObject child : Lists.newArrayList((Iterator)commentable.eAllContents())) {
                if (child instanceof LayoutInformation) continue;
                ++elementCount;
            }
        }
        return elementCount;
    }

    private List<Commentable> buildJaMoPPElementList(EList<SoftwareElement> elements1) {
        ArrayList jamoppElements1 = Lists.newArrayList();
        for (SoftwareElement se : elements1) {
            jamoppElements1.add((Commentable)se.getWrappedElement());
        }
        return jamoppElements1;
    }

    public String getName() {
        return ANALYZER_NAME;
    }

    public String getRelationshipLabel() {
        return RELATIONSHIP_LABEL;
    }

    public VPMAnalyzerConfigurationSet getConfigurations() {
        VPMAnalyzerConfigurationSet configurations = new VPMAnalyzerConfigurationSet();
        configurations.addConfigurations("General Configuations", new AbstractVPMAnalyzerConfiguration[]{this.minElementThresholdConfig});
        configurations.addConfigurations("General Configuations", new AbstractVPMAnalyzerConfiguration[]{this.detectionTypeConfig});
        return configurations;
    }
}

