/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.clonedchange;

import java.util.ArrayList;
import java.util.Collections;
import org.splevo.jamopp.algorithm.clones.baxtor.CloneDetectionType;
import org.splevo.vpm.analyzer.config.ChoiceConfiguration;
import org.splevo.vpm.analyzer.config.NumericConfiguration;
import org.splevo.vpm.analyzer.config.Range;

public final class Config {
    private static final String CONFIG_ID_BASE = "org.splevo.jamopp.vpm.analyzer.clonedchange";
    public static final String CONFIG_GROUP_GENERAL = "General Configuations";
    public static final String CONFIG_ID_INVOLVED_ELEMENT_THRESHOLD = "org.splevo.jamopp.vpm.analyzer.clonedchangeINVOLVED_ELEMENT_THRESHOLD";
    public static final String LABEL_INVOLVED_ELEMENT_THRESHOLD = "Minimum element threshold";
    public static final String EXPL_INVOLVED_ELEMENT_THRESHOLD = "The minimum number of model elements participating in a clone.";
    public static final int DEFAULT_INVOLVED_ELEMENT_THRESHOLD = 5;
    public static final String CONFIG_ID_DETECTION_TYPE = "org.splevo.jamopp.vpm.analyzer.clonedchangeDETECTION_TYPE";
    public static final String LABEL_DETECTION_TYPE = "Clone detection type";
    public static final String EXPL_DETECTION_TYPE = "The analysis type for clone detection";
    public static final String DEFAULT_DETECTION_TYPE = CloneDetectionType.STRUCTURAL.toString();

    private Config() {
    }

    public static NumericConfiguration createMinElementThresholdConfig() {
        return new NumericConfiguration(CONFIG_ID_INVOLVED_ELEMENT_THRESHOLD, LABEL_INVOLVED_ELEMENT_THRESHOLD, EXPL_INVOLVED_ELEMENT_THRESHOLD, 5, 1, new Range((Number)1, (Number)Integer.MAX_VALUE));
    }

    public static ChoiceConfiguration createDetectionTypeConfig() {
        ArrayList<String> values = new ArrayList<String>();
        CloneDetectionType[] cloneDetectionTypeArray = CloneDetectionType.values();
        int n = cloneDetectionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CloneDetectionType type = cloneDetectionTypeArray[n2];
            values.add(type.toString());
            ++n2;
        }
        Collections.sort(values);
        return new ChoiceConfiguration(CONFIG_ID_DETECTION_TYPE, LABEL_DETECTION_TYPE, EXPL_DETECTION_TYPE, DEFAULT_DETECTION_TYPE, values);
    }
}

