/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.programdependency.tests;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.DependencyType;
import org.splevo.jamopp.vpm.analyzer.programdependency.tests.RobillardSelectorTest;
import org.splevo.jamopp.vpm.analyzer.programdependency.tests.TestUtil;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.graph.VPMGraph;

public class RobillardExtendedSelectorTest
extends RobillardSelectorTest {
    private static final String BASE_PATH_EXTENDED = "testcode/robillardExtended/";

    @BeforeClass
    public static void setUpInfrastructure() {
        TestUtil.initLogging();
    }

    @Override
    @Before
    public void setUpAnalyzer() {
        this.analyzer = TestUtil.configureRobillardAnalyzer(true, false);
    }

    @Test
    public void testFieldCallsMethod() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/FieldCallsMethod/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.FieldCallsMethod, 1);
    }

    @Test
    public void testFieldCreatesClass() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/FieldCreatesClass/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.FieldCreatesClass, 1);
    }

    @Test
    public void testFieldImportClass() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/FieldImportClass/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 3);
        TestUtil.assertDependency(result, DependencyType.FieldImportClass, 2);
    }

    @Test
    public void testFieldImportEnumeration() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/FieldImportEnumeration/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 3);
        TestUtil.assertDependency(result, DependencyType.FieldImportEnumeration, 2);
    }

    @Test
    public void testFieldImportInterface() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/FieldImportInterface/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.FieldImportInterface, 1);
    }

    @Test
    public void testFieldReadsField() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/FieldReadsField/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.FieldReadsField, 1);
    }

    @Test
    public void testFieldTypedClass() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/FieldTypedClass/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.FieldTypedClass, 1);
    }

    @Test
    public void testFieldTypedEnumeration() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/FieldTypedEnumeration/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.FieldTypedEnumeration, 1);
    }

    @Test
    public void testFieldTypedInterface() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/FieldTypedInterface/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.FieldTypedInterface, 1);
    }

    @Test
    public void testInterfaceSuperTypeClass() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/InterfaceSuperTypeClass/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.InterfaceSuperTypeClass, 1);
    }

    @Test
    public void testInterfaceSuperTypeEnumeration() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/InterfaceSuperTypeEnumeration/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.InterfaceSuperTypeEnumeration, 1);
    }

    @Test
    public void testInterfaceSuperTypeInterface() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/InterfaceSuperTypeInterface/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.InterfaceSuperTypeInterface, 1);
    }

    @Test
    public void testMethodImportClass() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/MethodImportClass/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.MethodImportClass, 1);
    }

    @Test
    public void testMethodImportEnumeration() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/MethodImportEnumeration/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.MethodImportEnumeration, 1);
    }

    @Test
    public void testMethodImportInterface() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/MethodImportInterface/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.MethodImportInterface, 1);
    }

    @Test
    public void testMethodTypedClass() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/MethodTypedClass/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.MethodTypedClass, 1);
    }

    @Test
    public void testMethodTypedEnumeration() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/MethodTypedEnumeration/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.MethodTypedEnumeration, 1);
    }

    @Test
    public void testMethodTypedInterface() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/MethodTypedInterface/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.MethodTypedInterface, 1);
    }

    @Test
    public void testParameterTypedClass() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/ParameterTypedClass/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.ParameterTypedClass, 1);
    }

    @Test
    public void testParameterTypedEnumeration() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/ParameterTypedEnumeration/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.ParameterTypedEnumeration, 1);
    }

    @Test
    public void testParameterTypedInterface() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/ParameterTypedInterface/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.ParameterTypedInterface, 1);
    }

    @Test
    public void testStatementChecksEnumerationCast() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/StatementChecksEnumeration/Cast/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.StatementChecksEnumeration, 1);
    }

    @Test
    public void testStatementChecksEnumerationInstanceOf() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/StatementChecksEnumeration/InstanceOf/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.StatementChecksEnumeration, 1);
    }

    @Test
    public void testStatementChecksInterfaceInstanceOf() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/StatementChecksInterface/InstanceOf/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.StatementChecksInterface, 1);
    }

    @Test
    public void testStatementImportClass() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/StatementImportClass/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.StatementImportClass, 1);
    }

    @Test
    public void testStatementImportEnumeration() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/StatementImportEnumeration/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.StatementImportEnumeration, 1);
    }

    @Test
    public void testStatementImportInterface() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/StatementImportInterface/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.StatementImportInterface, 1);
    }

    @Test
    public void testStatementModifiesField() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/StatementModifiesField/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 4);
        TestUtil.assertDependency(result, DependencyType.StatementModifiesField, 2);
    }

    @Test
    public void testStatementModifiesVariable() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/StatementModifiesVariable/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 8);
        TestUtil.assertDependency(result, DependencyType.StatementModifiesVariable, 4);
    }

    @Test
    public void testStatementReadsVariable() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/StatementReadsVariable/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 8);
        TestUtil.assertDependency(result, DependencyType.StatementReadsVariable, 4);
    }

    @Test
    public void testStatementReadsVariableAsAttribute() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/StatementReadsVariableAsAttribute/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.StatementReadsVariable, 1);
    }

    @Test
    public void testStatementReadsVariableInCast() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/StatementReadsVariableInCast/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.StatementReadsVariable, 1);
    }

    @Test
    public void testStatementTypedClass() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/StatementTypedClass/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.StatementTypedClass, 1);
    }

    @Test
    public void testStatementTypedEnumeration() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/StatementTypedEnumeration/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.StatementTypedEnumeration, 1);
    }

    @Test
    public void testStatementTypedInterface() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/StatementTypedInterface/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.StatementTypedInterface, 1);
    }

    @Test
    public void testStatementWritesVariable() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/StatementWritesVariable/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 4);
        TestUtil.assertDependency(result, DependencyType.StatementWritesVariable, 2);
    }

    @Test
    public void testStatementChecksInterfaceCast() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillardExtended/StatementChecksInterface/Cast/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.StatementChecksInterface, 1);
    }
}

