/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.programdependency.tests;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.jamopp.vpm.analyzer.programdependency.JaMoPPProgramDependencyVPMAnalyzer;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.DependencyType;
import org.splevo.jamopp.vpm.analyzer.programdependency.tests.TestUtil;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.graph.VPMGraph;

public class RobillardSelectorTest {
    private static final String BASE_PATH = "testcode/robillard/";
    protected JaMoPPProgramDependencyVPMAnalyzer analyzer = null;

    @BeforeClass
    public static void setUpInfrastructure() {
        TestUtil.initLogging();
    }

    @Before
    public void setUpAnalyzer() {
        this.analyzer = TestUtil.configureRobillardAnalyzer(false, false);
    }

    @Test
    public void testClassSupertypeClass() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillard/ClassSupertypeClass/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.ClassSuperTypeClass, 1);
    }

    @Test
    public void testStatementCallsMethod() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillard/StatementCallsMethod/basic/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 3);
        TestUtil.assertDependency(result, DependencyType.StatementCallsMethod, 1);
    }

    @Test
    public void testStatementCallsMethodConstructor() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillard/StatementCallsMethod/constructor/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.StatementCallsMethod, 1);
    }

    @Test
    public void testStatementChecksClassInstanceOf() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillard/StatementChecksClass/InstanceOf/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.StatementChecksClass, 1);
    }

    @Test
    public void testStatementChecksClassClassCast() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillard/StatementChecksClass/ClassCast/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.StatementChecksClass, 1);
    }

    @Test
    public void testStatementCreatesClass() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillard/StatementCreatesClass/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.StatementCreatesClass, 1);
    }

    @Test
    public void testStatementReadsField() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillard/StatementReadsField/basic/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 4);
        TestUtil.assertDependency(result, DependencyType.StatementReadsField, 2);
    }

    @Test
    public void testStatementReadsFieldNested() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillard/StatementReadsField/nested/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 10);
        TestUtil.assertDependency(result, DependencyType.StatementReadsField, 5);
    }

    @Test
    public void testStatementReadsFieldThis() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillard/StatementReadsField/this/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependency(result, DependencyType.StatementReadsField, 1);
    }

    @Test
    public void testStatementWritesField() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/robillard/StatementWritesField/");
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        TestUtil.assertNodeCount(graph, 4);
        TestUtil.assertDependency(result, DependencyType.StatementWritesField, 2);
    }
}

