/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.programdependency.tests;

import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.jamopp.vpm.analyzer.programdependency.JaMoPPProgramDependencyVPMAnalyzer;
import org.splevo.jamopp.vpm.analyzer.programdependency.tests.TestUtil;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.graph.VPMGraph;

public class SharedAccessTest {
    private static final String BASE_PATH = "testcode/sharedAccess/";

    @BeforeClass
    public static void setUp() {
        TestUtil.initLogging();
    }

    @Test
    public void testSharedVariableAccess() throws Exception {
        JaMoPPProgramDependencyVPMAnalyzer analyzerSharedMode = TestUtil.configureRobillardAnalyzer(true, true);
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/sharedAccess/VariableUsage/");
        VPMAnalyzerResult result = analyzerSharedMode.analyze(graph);
        TestUtil.assertNodeCount(graph, 2);
        TestUtil.assertDependencyCount(result, 1);
    }

    @Test
    public void testJavaLangMethodCallNotShared() throws Exception {
        JaMoPPProgramDependencyVPMAnalyzer analyzerExtendedMode = TestUtil.configureRobillardAnalyzer(true, false);
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/sharedAccess/JavaLangMethodCall/");
        VPMAnalyzerResult result = analyzerExtendedMode.analyze(graph);
        TestUtil.assertNodeCount(graph, 6);
        TestUtil.assertDependencyCount(result, 4);
    }
}

