/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.programdependency.references;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.emftext.language.java.commons.Commentable;
import org.splevo.jamopp.util.JaMoPPElementUtil;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.DependencyType;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.Reference;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.ReferenceSelector;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.RobillardReferenceSelectorSwitch;
import org.splevo.vpm.analyzer.VPMAnalyzerUtil;

public class RobillardReferenceSelector
implements ReferenceSelector {
    private static Logger logger = Logger.getLogger(RobillardReferenceSelector.class);
    private RobillardReferenceSelectorSwitch selectorSwitch;
    private boolean sharedAccess = false;

    public RobillardReferenceSelector(boolean extendedMode, boolean sharedAccess) {
        this.sharedAccess = sharedAccess;
        this.selectorSwitch = new RobillardReferenceSelectorSwitch(extendedMode);
    }

    @Override
    public List<Reference> getReferencedElements(Commentable commentable) {
        if (VPMAnalyzerUtil.isNullOrProxy((EObject)commentable)) {
            return new ArrayList<Reference>();
        }
        Object references = this.selectorSwitch.doSwitch((EObject)commentable);
        ArrayList referencesToRemove = Lists.newArrayList();
        Iterator iterator = references.iterator();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            if (!VPMAnalyzerUtil.isNullOrProxy((EObject)reference.getTarget())) continue;
            referencesToRemove.add(reference);
        }
        references.removeAll(referencesToRemove);
        return references;
    }

    @Override
    public DependencyType getDependencyType(Reference reference1, Reference reference2, Commentable target) {
        if (reference1.getSource() == reference2.getSource()) {
            return DependencyType.IGNORE;
        }
        boolean source1IsParent = JaMoPPElementUtil.isParentOf((Commentable)reference1.getSource(), (Commentable)target);
        boolean source2IsParent = JaMoPPElementUtil.isParentOf((Commentable)reference2.getSource(), (Commentable)target);
        DependencyType dependencyType = null;
        if (source1IsParent && source2IsParent) {
            logger.error((Object)"Unexpected Nested sources");
            return DependencyType.IGNORE;
        }
        if (source1IsParent) {
            dependencyType = reference2.getDependencyType();
        } else if (source2IsParent) {
            dependencyType = reference1.getDependencyType();
        } else if (this.sharedAccess) {
            logger.info((Object)String.format("SHARED: %s & %s", new Object[]{reference1.getType(), reference2.getType()}));
            dependencyType = DependencyType.SHARED;
        } else {
            return DependencyType.IGNORE;
        }
        return dependencyType;
    }
}

