/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.programdependency.references;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.Switch;
import org.emftext.language.java.classifiers.Class;
import org.emftext.language.java.classifiers.ConcreteClassifier;
import org.emftext.language.java.classifiers.Enumeration;
import org.emftext.language.java.classifiers.Interface;
import org.emftext.language.java.classifiers.util.ClassifiersSwitch;
import org.emftext.language.java.commons.Commentable;
import org.emftext.language.java.containers.CompilationUnit;
import org.emftext.language.java.containers.util.ContainersSwitch;
import org.emftext.language.java.expressions.AssignmentExpression;
import org.emftext.language.java.expressions.CastExpression;
import org.emftext.language.java.expressions.Expression;
import org.emftext.language.java.expressions.ExpressionList;
import org.emftext.language.java.expressions.InstanceOfExpression;
import org.emftext.language.java.expressions.util.ExpressionsSwitch;
import org.emftext.language.java.imports.Import;
import org.emftext.language.java.imports.util.ImportsSwitch;
import org.emftext.language.java.instantiations.NewConstructorCall;
import org.emftext.language.java.instantiations.util.InstantiationsSwitch;
import org.emftext.language.java.members.AdditionalField;
import org.emftext.language.java.members.ClassMethod;
import org.emftext.language.java.members.Constructor;
import org.emftext.language.java.members.Field;
import org.emftext.language.java.members.Member;
import org.emftext.language.java.members.Method;
import org.emftext.language.java.members.util.MembersSwitch;
import org.emftext.language.java.parameters.Parameter;
import org.emftext.language.java.parameters.util.ParametersSwitch;
import org.emftext.language.java.references.IdentifierReference;
import org.emftext.language.java.references.MethodCall;
import org.emftext.language.java.references.ReferenceableElement;
import org.emftext.language.java.references.SelfReference;
import org.emftext.language.java.references.util.ReferencesSwitch;
import org.emftext.language.java.statements.CatchBlock;
import org.emftext.language.java.statements.Condition;
import org.emftext.language.java.statements.ExpressionStatement;
import org.emftext.language.java.statements.ForLoop;
import org.emftext.language.java.statements.LocalVariableStatement;
import org.emftext.language.java.statements.Return;
import org.emftext.language.java.statements.Statement;
import org.emftext.language.java.statements.StatementListContainer;
import org.emftext.language.java.statements.TryBlock;
import org.emftext.language.java.statements.WhileLoop;
import org.emftext.language.java.statements.util.StatementsSwitch;
import org.emftext.language.java.types.Type;
import org.emftext.language.java.types.TypeReference;
import org.emftext.language.java.types.util.TypesSwitch;
import org.emftext.language.java.variables.AdditionalLocalVariable;
import org.emftext.language.java.variables.LocalVariable;
import org.splevo.jamopp.util.JaMoPPElementUtil;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.Reference;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.ReferenceType;
import org.splevo.vpm.analyzer.VPMAnalyzerUtil;

public class RobillardReferenceSelectorSwitch
extends ComposedSwitch<List<Reference>> {
    private Logger logger = Logger.getLogger(RobillardReferenceSelectorSwitch.class);
    private boolean extendedMode = true;

    public RobillardReferenceSelectorSwitch(boolean extendedMode) {
        this.extendedMode = extendedMode;
        this.addSwitch((Switch)new ClassifiersReferencedElementsSwitch(this));
        this.addSwitch((Switch)new MembersReferencedElementsSwitch(this));
        this.addSwitch((Switch)new StatementsReferencedElementsSwitch(this));
        this.addSwitch((Switch)new ReferencesReferencedElementsSwitch(this));
        this.addSwitch((Switch)new InstantiationsReferencedElementsSwitch(this));
        this.addSwitch((Switch)new ExpressionsReferencedElementsSwitch(this));
        this.addSwitch((Switch)new ContainersReferencedElementsSwitch(this));
        this.addSwitch((Switch)new TypesReferencedElementsSwitch(this));
        if (extendedMode) {
            this.addSwitch((Switch)new ImportReferencedElementsSwitch());
            this.addSwitch((Switch)new ParametersReferencedElementsSwitch(this));
        }
    }

    private void updateSource(Commentable source, List<Reference> references) {
        for (Reference reference : references) {
            reference.setSource(source);
        }
    }

    private void updateType(ReferenceType type, List<Reference> references) {
        for (Reference reference : references) {
            reference.setType(type);
        }
    }

    private void updateType(ReferenceType oldType, ReferenceType newType, List<Reference> references) {
        for (Reference reference : references) {
            if (reference.getType() != oldType) continue;
            reference.setType(newType);
        }
    }

    public List<Reference> doSwitch(EObject eObject) {
        List elements = null;
        if (!VPMAnalyzerUtil.isNullOrProxy((EObject)eObject)) {
            elements = (List)super.doSwitch(eObject);
        }
        if (elements == null) {
            elements = Lists.newArrayList();
        }
        return elements;
    }

    private class ClassifiersReferencedElementsSwitch
    extends ClassifiersSwitch<List<Reference>> {
        private RobillardReferenceSelectorSwitch parentSwitch;

        public ClassifiersReferencedElementsSwitch(RobillardReferenceSelectorSwitch parentSwitch) {
            this.parentSwitch = parentSwitch;
        }

        public List<Reference> caseClass(Class classObject) {
            ArrayList references = Lists.newArrayList();
            for (Member member : classObject.getMembers()) {
                if (member instanceof Field || member instanceof Method || member instanceof Constructor) {
                    references.add(new Reference((Commentable)classObject, (Commentable)member, ReferenceType.Declares));
                }
                references.addAll(this.parentSwitch.doSwitch((EObject)member));
            }
            TypeReference extendsReference = classObject.getExtends();
            if (extendsReference != null) {
                references.add(new Reference((Commentable)classObject, (Commentable)extendsReference.getTarget(), ReferenceType.SuperType));
            }
            for (TypeReference implementsReference : classObject.getImplements()) {
                references.add(new Reference((Commentable)classObject, (Commentable)implementsReference.getTarget(), ReferenceType.SuperType));
            }
            references.add(new Reference((Commentable)classObject));
            return references;
        }

        public List<Reference> caseInterface(Interface interfaceObject) {
            if (RobillardReferenceSelectorSwitch.this.extendedMode) {
                ArrayList references = Lists.newArrayList();
                for (Member member : interfaceObject.getMembers()) {
                    references.addAll(this.parentSwitch.doSwitch((EObject)member));
                }
                RobillardReferenceSelectorSwitch.this.updateType(ReferenceType.Declares, references);
                for (TypeReference typeRef : interfaceObject.getExtends()) {
                    references.add(new Reference((Commentable)interfaceObject, (Commentable)typeRef.getTarget(), ReferenceType.SuperType));
                }
                references.add(new Reference((Commentable)interfaceObject));
                return references;
            }
            return null;
        }

        public List<Reference> caseEnumeration(Enumeration enumeration) {
            if (RobillardReferenceSelectorSwitch.this.extendedMode) {
                ArrayList references = Lists.newArrayList();
                for (Member member : enumeration.getMembers()) {
                    references.addAll(this.parentSwitch.doSwitch((EObject)member));
                }
                RobillardReferenceSelectorSwitch.this.updateType(ReferenceType.Declares, references);
                for (TypeReference typeRef : enumeration.getImplements()) {
                    references.add(new Reference((Commentable)enumeration, (Commentable)typeRef.getTarget(), ReferenceType.SuperType));
                }
                references.add(new Reference((Commentable)enumeration));
                return references;
            }
            return null;
        }
    }

    private class ContainersReferencedElementsSwitch
    extends ContainersSwitch<List<Reference>> {
        private RobillardReferenceSelectorSwitch parentSwitch;

        public ContainersReferencedElementsSwitch(RobillardReferenceSelectorSwitch parentSwitch) {
            this.parentSwitch = parentSwitch;
        }

        public List<Reference> caseCompilationUnit(CompilationUnit cu) {
            ArrayList references = Lists.newArrayList();
            for (ConcreteClassifier cc : cu.getClassifiers()) {
                references.addAll(this.parentSwitch.doSwitch((EObject)cc));
            }
            return references;
        }
    }

    private class ExpressionsReferencedElementsSwitch
    extends ExpressionsSwitch<List<Reference>> {
        private RobillardReferenceSelectorSwitch parentSwitch;

        public ExpressionsReferencedElementsSwitch(RobillardReferenceSelectorSwitch parentSwitch) {
            this.parentSwitch = parentSwitch;
        }

        public List<Reference> caseExpressionList(ExpressionList exp) {
            ArrayList refElements = Lists.newArrayList();
            for (Expression expression : exp.getExpressions()) {
                refElements.addAll(this.parentSwitch.doSwitch((EObject)expression));
            }
            return refElements;
        }

        public List<Reference> caseAssignmentExpression(AssignmentExpression exp) {
            ArrayList references = Lists.newArrayList();
            references.addAll(this.parentSwitch.doSwitch((EObject)exp.getChild()));
            RobillardReferenceSelectorSwitch.this.updateType(ReferenceType.Reads, ReferenceType.Writes, references);
            references.addAll(this.parentSwitch.doSwitch((EObject)exp.getValue()));
            return references;
        }

        public List<Reference> caseCastExpression(CastExpression exp) {
            ArrayList refElements = Lists.newArrayList();
            refElements.add(new Reference((Commentable)exp, (Commentable)exp.getAlternativeType(), ReferenceType.Checks));
            refElements.addAll(this.parentSwitch.doSwitch((EObject)exp.getChild()));
            return refElements;
        }

        public List<Reference> caseInstanceOfExpression(InstanceOfExpression iof) {
            ArrayList refElements = Lists.newArrayList();
            refElements.add(new Reference((Commentable)iof, (Commentable)iof.getTypeReference().getTarget(), ReferenceType.Checks));
            return refElements;
        }
    }

    private class ImportReferencedElementsSwitch
    extends ImportsSwitch<List<Reference>> {
        private ImportReferencedElementsSwitch() {
        }

        public List<Reference> caseImport(Import importDecl) {
            return Lists.newArrayList((Object[])new Reference[]{new Reference((Commentable)importDecl)});
        }
    }

    private class InstantiationsReferencedElementsSwitch
    extends InstantiationsSwitch<List<Reference>> {
        private RobillardReferenceSelectorSwitch parentSwitch;

        public InstantiationsReferencedElementsSwitch(RobillardReferenceSelectorSwitch parentSwitch) {
            this.parentSwitch = parentSwitch;
        }

        public List<Reference> caseNewConstructorCall(NewConstructorCall call) {
            Import importDecl;
            ArrayList references = Lists.newArrayList();
            for (Expression expression : call.getArguments()) {
                references.addAll(this.parentSwitch.doSwitch((EObject)expression));
            }
            Constructor constructor = JaMoPPElementUtil.getConstructor((NewConstructorCall)call);
            if (constructor != null) {
                references.add(new Reference((Commentable)call, (Commentable)constructor, ReferenceType.Calls));
            }
            Type type = call.getReferencedType();
            references.add(new Reference((Commentable)call, (Commentable)type, ReferenceType.Creates));
            if (RobillardReferenceSelectorSwitch.this.extendedMode && (importDecl = JaMoPPElementUtil.checkForImport((Commentable)call, (Type)type)) != null) {
                references.add(new Reference((Commentable)call, (Commentable)importDecl, ReferenceType.Import));
            }
            references.addAll(this.parentSwitch.doSwitch((EObject)call.getNext()));
            return references;
        }
    }

    private class MembersReferencedElementsSwitch
    extends MembersSwitch<List<Reference>> {
        private RobillardReferenceSelectorSwitch parentSwitch;

        public MembersReferencedElementsSwitch(RobillardReferenceSelectorSwitch parentSwitch) {
            this.parentSwitch = parentSwitch;
        }

        public List<Reference> caseConstructor(Constructor constructor) {
            ArrayList references = Lists.newArrayList();
            for (Statement statement : constructor.getStatements()) {
                references.addAll(this.parentSwitch.doSwitch((EObject)statement));
            }
            references.add(new Reference((Commentable)constructor));
            return references;
        }

        public List<Reference> caseClassMethod(ClassMethod method) {
            ArrayList references = Lists.newArrayList();
            Object commonMethodReferences = this.caseMethod((Method)method);
            references.addAll(commonMethodReferences);
            for (Statement statement : method.getStatements()) {
                references.addAll(this.parentSwitch.doSwitch((EObject)statement));
            }
            references.add(new Reference((Commentable)method));
            return references;
        }

        public List<Reference> caseMethod(Method method) {
            ArrayList references = Lists.newArrayList();
            if (RobillardReferenceSelectorSwitch.this.extendedMode) {
                for (Parameter parameter : method.getParameters()) {
                    references.addAll(this.parentSwitch.doSwitch((EObject)parameter));
                }
                Type type = method.getTypeReference().getTarget();
                references.add(new Reference((Commentable)method, (Commentable)type, ReferenceType.Typed));
                Import importDecl = JaMoPPElementUtil.checkForImport((Commentable)method, (Type)type);
                if (importDecl != null) {
                    references.add(new Reference((Commentable)method, (Commentable)importDecl, ReferenceType.Import));
                }
            }
            references.add(new Reference((Commentable)method));
            return references;
        }

        public List<Reference> caseField(Field field) {
            ArrayList references = Lists.newArrayList();
            if (RobillardReferenceSelectorSwitch.this.extendedMode) {
                Expression initialValue = field.getInitialValue();
                references.addAll(this.parentSwitch.doSwitch((EObject)initialValue));
                RobillardReferenceSelectorSwitch.this.updateSource((Commentable)field, references);
                Type type = field.getTypeReference().getTarget();
                references.add(new Reference((Commentable)field, (Commentable)type, ReferenceType.Typed));
                Import importDecl = JaMoPPElementUtil.checkForImport((Commentable)field, (Type)type);
                if (importDecl != null) {
                    references.add(new Reference((Commentable)field, (Commentable)importDecl, ReferenceType.Import));
                }
            }
            references.add(new Reference((Commentable)field));
            for (AdditionalField addField : field.getAdditionalFields()) {
                references.add(new Reference((Commentable)addField));
            }
            return references;
        }
    }

    private class ParametersReferencedElementsSwitch
    extends ParametersSwitch<List<Reference>> {
        private RobillardReferenceSelectorSwitch parentSwitch;

        public ParametersReferencedElementsSwitch(RobillardReferenceSelectorSwitch parentSwitch) {
            this.parentSwitch = parentSwitch;
        }

        public List<Reference> caseParameter(Parameter parameter) {
            ArrayList refElements = Lists.newArrayList();
            Type type = parameter.getTypeReference().getTarget();
            refElements.add(new Reference((Commentable)parameter, (Commentable)type, ReferenceType.Typed));
            Import importDecl = JaMoPPElementUtil.checkForImport((Commentable)parameter, (Type)type);
            if (importDecl != null) {
                refElements.add(new Reference((Commentable)parameter, (Commentable)importDecl, ReferenceType.Import));
            }
            return refElements;
        }
    }

    private class ReferencesReferencedElementsSwitch
    extends ReferencesSwitch<List<Reference>> {
        private RobillardReferenceSelectorSwitch parentSwitch;

        public ReferencesReferencedElementsSwitch(RobillardReferenceSelectorSwitch parentSwitch) {
            this.parentSwitch = parentSwitch;
        }

        public List<Reference> caseMethodCall(MethodCall call) {
            ArrayList refElements = Lists.newArrayList((Object[])new Reference[]{new Reference((Commentable)call, (Commentable)call.getTarget(), ReferenceType.Calls)});
            for (Expression expression : call.getArguments()) {
                refElements.addAll(this.parentSwitch.doSwitch((EObject)expression));
            }
            RobillardReferenceSelectorSwitch.this.updateSource((Commentable)call, refElements);
            refElements.addAll(this.parentSwitch.doSwitch((EObject)call.getNext()));
            return refElements;
        }

        public List<Reference> caseSelfReference(SelfReference self) {
            return this.parentSwitch.doSwitch((EObject)self.getNext());
        }

        public List<Reference> caseIdentifierReference(IdentifierReference identifierRef) {
            ArrayList references = Lists.newArrayList();
            ReferenceableElement target = identifierRef.getTarget();
            if (target instanceof Field || target instanceof AdditionalField) {
                if (identifierRef.getNext() == null) {
                    references.add(new Reference((Commentable)identifierRef, (Commentable)target, ReferenceType.Reads));
                } else if (RobillardReferenceSelectorSwitch.this.extendedMode && identifierRef.getNext() instanceof MethodCall || identifierRef.getNext() instanceof IdentifierReference && (((IdentifierReference)identifierRef.getNext()).getTarget() instanceof Field || ((IdentifierReference)identifierRef.getNext()).getTarget() instanceof AdditionalField)) {
                    references.add(new Reference((Commentable)identifierRef, (Commentable)target, ReferenceType.Modifies));
                }
            } else if (target instanceof Method) {
                references.add(new Reference((Commentable)identifierRef, (Commentable)target, ReferenceType.Calls));
            } else if (RobillardReferenceSelectorSwitch.this.extendedMode) {
                if (target instanceof Type) {
                    Import importDecl = JaMoPPElementUtil.checkForImport((Commentable)identifierRef, (Type)((Type)target));
                    if (importDecl != null) {
                        references.add(new Reference((Commentable)identifierRef, (Commentable)importDecl, ReferenceType.Import));
                    }
                } else if (target instanceof LocalVariable || target instanceof AdditionalLocalVariable || target instanceof Parameter) {
                    if (identifierRef.getNext() == null) {
                        references.add(new Reference((Commentable)identifierRef, (Commentable)target, ReferenceType.Reads));
                    } else if (identifierRef.getNext() instanceof MethodCall || identifierRef.getNext() instanceof IdentifierReference && ((IdentifierReference)identifierRef.getNext()).getTarget() instanceof Field || ((IdentifierReference)identifierRef.getNext()).getTarget() instanceof AdditionalField) {
                        references.add(new Reference((Commentable)identifierRef, (Commentable)target, ReferenceType.Modifies));
                    }
                }
            }
            if (identifierRef.getNext() != null) {
                references.addAll(this.parentSwitch.doSwitch((EObject)identifierRef.getNext()));
            }
            return references;
        }
    }

    private class StatementsReferencedElementsSwitch
    extends StatementsSwitch<List<Reference>> {
        private RobillardReferenceSelectorSwitch parentSwitch;

        public StatementsReferencedElementsSwitch(RobillardReferenceSelectorSwitch parentSwitch) {
            this.parentSwitch = parentSwitch;
        }

        public List<Reference> caseReturn(Return returnStmt) {
            Object refElements = this.parentSwitch.doSwitch((EObject)returnStmt.getReturnValue());
            RobillardReferenceSelectorSwitch.this.updateSource((Commentable)returnStmt, (List)refElements);
            return refElements;
        }

        public List<Reference> caseTryBlock(TryBlock block) {
            ArrayList refElements = Lists.newArrayList();
            for (Statement statement : block.getStatements()) {
                refElements.addAll(this.parentSwitch.doSwitch((EObject)statement));
            }
            for (CatchBlock catchBlock : block.getCatcheBlocks()) {
                refElements.addAll(this.caseCatchBlock(catchBlock));
            }
            return refElements;
        }

        public List<Reference> caseCatchBlock(CatchBlock block) {
            ArrayList references = Lists.newArrayList();
            for (Statement statement : block.getStatements()) {
                references.addAll(this.parentSwitch.doSwitch((EObject)statement));
            }
            references.addAll(this.parentSwitch.doSwitch((EObject)block.getParameter()));
            return references;
        }

        public List<Reference> caseCondition(Condition condition) {
            Object refElements = this.parentSwitch.doSwitch((EObject)condition.getCondition());
            RobillardReferenceSelectorSwitch.this.updateSource((Commentable)condition, (List)refElements);
            refElements.addAll(this.parentSwitch.doSwitch((EObject)condition.getElseStatement()));
            refElements.addAll(this.parentSwitch.doSwitch((EObject)condition.getStatement()));
            return refElements;
        }

        public List<Reference> caseForLoop(ForLoop loop) {
            Object refElements = this.parentSwitch.doSwitch((EObject)loop.getInit());
            refElements.addAll(this.parentSwitch.doSwitch((EObject)loop.getCondition()));
            RobillardReferenceSelectorSwitch.this.updateSource((Commentable)loop, (List)refElements);
            refElements.addAll(this.parentSwitch.doSwitch((EObject)loop.getStatement()));
            return refElements;
        }

        public List<Reference> caseWhileLoop(WhileLoop loop) {
            Object refElements = this.parentSwitch.doSwitch((EObject)loop.getCondition());
            RobillardReferenceSelectorSwitch.this.updateSource((Commentable)loop, (List)refElements);
            refElements.addAll(this.parentSwitch.doSwitch((EObject)loop.getStatement()));
            return refElements;
        }

        public List<Reference> caseStatementListContainer(StatementListContainer container) {
            ArrayList references = Lists.newArrayList();
            for (Statement statement : container.getStatements()) {
                references.addAll(this.parentSwitch.doSwitch((EObject)statement));
            }
            return references;
        }

        public List<Reference> caseExpressionStatement(ExpressionStatement stmt) {
            Object references = this.parentSwitch.doSwitch((EObject)stmt.getExpression());
            RobillardReferenceSelectorSwitch.this.updateSource((Commentable)stmt, (List)references);
            return references;
        }

        public List<Reference> caseLocalVariableStatement(LocalVariableStatement lvs) {
            LocalVariable variable = lvs.getVariable();
            Object refElements = this.parentSwitch.doSwitch((EObject)variable.getInitialValue());
            RobillardReferenceSelectorSwitch.this.updateSource((Commentable)lvs, (List)refElements);
            if (RobillardReferenceSelectorSwitch.this.extendedMode) {
                refElements.add(new Reference((Commentable)lvs, (Commentable)variable, ReferenceType.Declares));
                for (AdditionalLocalVariable var : variable.getAdditionalLocalVariables()) {
                    refElements.add(new Reference((Commentable)lvs, (Commentable)var, ReferenceType.Declares));
                }
                Type varType = variable.getTypeReference().getTarget();
                refElements.add(new Reference((Commentable)lvs, (Commentable)varType, ReferenceType.Typed));
                Import importDecl = JaMoPPElementUtil.checkForImport((Commentable)lvs, (Type)varType);
                if (importDecl != null) {
                    refElements.add(new Reference((Commentable)lvs, (Commentable)importDecl, ReferenceType.Import));
                }
            }
            return refElements;
        }
    }

    private class TypesReferencedElementsSwitch
    extends TypesSwitch<List<Reference>> {
        private RobillardReferenceSelectorSwitch parentSwitch;

        public TypesReferencedElementsSwitch(RobillardReferenceSelectorSwitch parentSwitch) {
            this.parentSwitch = parentSwitch;
        }

        public List<Reference> caseTypeReference(TypeReference reference) {
            ArrayList references = Lists.newArrayList();
            Commentable refererrer = (Commentable)reference.eContainer();
            Type target = reference.getTarget();
            references.add(new Reference(refererrer, (Commentable)target, ReferenceType.SuperType));
            return references;
        }
    }
}

