/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.builder;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.ecore.EObject;
import org.emftext.language.java.classifiers.Class;
import org.emftext.language.java.classifiers.Enumeration;
import org.emftext.language.java.classifiers.Interface;
import org.emftext.language.java.commons.Commentable;
import org.emftext.language.java.containers.CompilationUnit;
import org.emftext.language.java.containers.Package;
import org.emftext.language.java.imports.Import;
import org.emftext.language.java.members.Constructor;
import org.emftext.language.java.members.Field;
import org.emftext.language.java.members.Method;
import org.emftext.language.java.statements.Block;
import org.emftext.language.java.statements.Statement;
import org.emftext.language.java.types.TypeReference;
import org.splevo.jamopp.diffing.jamoppdiff.ClassChange;
import org.splevo.jamopp.diffing.jamoppdiff.CompilationUnitChange;
import org.splevo.jamopp.diffing.jamoppdiff.ConstructorChange;
import org.splevo.jamopp.diffing.jamoppdiff.EnumChange;
import org.splevo.jamopp.diffing.jamoppdiff.ExtendsChange;
import org.splevo.jamopp.diffing.jamoppdiff.FieldChange;
import org.splevo.jamopp.diffing.jamoppdiff.ImplementsChange;
import org.splevo.jamopp.diffing.jamoppdiff.ImportChange;
import org.splevo.jamopp.diffing.jamoppdiff.InterfaceChange;
import org.splevo.jamopp.diffing.jamoppdiff.MethodChange;
import org.splevo.jamopp.diffing.jamoppdiff.PackageChange;
import org.splevo.jamopp.diffing.jamoppdiff.StatementChange;
import org.splevo.jamopp.diffing.jamoppdiff.util.JaMoPPDiffSwitch;
import org.splevo.jamopp.vpm.software.JaMoPPJavaSoftwareElement;
import org.splevo.jamopp.vpm.software.JaMoPPSoftwareElement;
import org.splevo.jamopp.vpm.software.softwareFactory;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointModel;
import org.splevo.vpm.variability.variabilityFactory;

class JaMoPPDiffVisitor
extends JaMoPPDiffSwitch<VariationPoint> {
    private Logger logger = Logger.getLogger(JaMoPPDiffVisitor.class);
    private String variantIDLeading = null;
    private String variantIDIntegration = null;
    private VariationPointModel vpm = null;
    private Comparison comparison = null;
    private Map<Commentable, JaMoPPJavaSoftwareElement> elementRegistry = Maps.newLinkedHashMap();

    public JaMoPPDiffVisitor(String variantIDLeading, String variantIDIntegration, VariationPointModel vpm, Comparison comparison) {
        this.variantIDIntegration = variantIDIntegration;
        this.variantIDLeading = variantIDLeading;
        this.vpm = vpm;
        this.comparison = comparison;
    }

    public VariationPoint casePackageChange(PackageChange change) {
        Package changedElement = change.getChangedPackage();
        return this.buildKindSpecificVariationPoint((Diff)change, (Commentable)changedElement);
    }

    public VariationPoint caseCompilationUnitChange(CompilationUnitChange change) {
        CompilationUnit changedElement = change.getChangedCompilationUnit();
        return this.buildKindSpecificVariationPoint((Diff)change, (Commentable)changedElement);
    }

    public VariationPoint caseImportChange(ImportChange change) {
        Import changedElement = change.getChangedImport();
        return this.buildKindSpecificVariationPoint((Diff)change, (Commentable)changedElement);
    }

    public VariationPoint caseClassChange(ClassChange change) {
        Class changedElement = change.getChangedClass();
        return this.buildKindSpecificVariationPoint((Diff)change, (Commentable)changedElement);
    }

    public VariationPoint caseImplementsChange(ImplementsChange change) {
        TypeReference changedElement = change.getChangedReference();
        return this.buildKindSpecificVariationPoint((Diff)change, (Commentable)changedElement);
    }

    public VariationPoint caseExtendsChange(ExtendsChange change) {
        TypeReference changedElement = change.getChangedReference();
        return this.buildKindSpecificVariationPoint((Diff)change, (Commentable)changedElement);
    }

    public VariationPoint caseInterfaceChange(InterfaceChange change) {
        Interface changedElement = change.getChangedInterface();
        return this.buildKindSpecificVariationPoint((Diff)change, (Commentable)changedElement);
    }

    public VariationPoint caseFieldChange(FieldChange change) {
        Field changedElement = change.getChangedField();
        return this.buildKindSpecificVariationPoint((Diff)change, (Commentable)changedElement);
    }

    public VariationPoint caseMethodChange(MethodChange change) {
        Method changedElement = change.getChangedMethod();
        return this.buildKindSpecificVariationPoint((Diff)change, (Commentable)changedElement);
    }

    public VariationPoint caseConstructorChange(ConstructorChange change) {
        Constructor changedElement = change.getChangedConstructor();
        return this.buildKindSpecificVariationPoint((Diff)change, (Commentable)changedElement);
    }

    public VariationPoint caseStatementChange(StatementChange change) {
        Statement changedElement = change.getChangedStatement();
        return this.buildKindSpecificVariationPoint((Diff)change, (Commentable)changedElement);
    }

    public VariationPoint caseEnumChange(EnumChange change) {
        Enumeration changedElement = change.getChangedEnum();
        return this.buildKindSpecificVariationPoint((Diff)change, (Commentable)changedElement);
    }

    public VariationPoint defaultCase(EObject object) {
        this.logger.error((Object)("Unhandled DiffType: " + object.getClass()));
        return null;
    }

    private VariationPoint buildKindSpecificVariationPoint(Diff diff, Commentable changedCommentable) {
        Commentable parent = this.getParentNode(changedCommentable);
        switch (diff.getKind()) {
            case ADD: {
                return this.createVariationPointInsert(changedCommentable, parent);
            }
            case DELETE: {
                return this.createVariationPointDelete(changedCommentable, parent);
            }
            case CHANGE: {
                return this.createVariationPointChange((EObject)changedCommentable, parent);
            }
        }
        this.logger.error((Object)("Unhandled change: " + diff));
        return null;
    }

    private VariationPoint createVariationPointInsert(Commentable newElement, Commentable parentNode) {
        VariationPoint variationPoint = variabilityFactory.eINSTANCE.createVariationPoint();
        if (parentNode != null) {
            JaMoPPJavaSoftwareElement enclosingSoftwareElement = this.createSoftwareElement(parentNode);
            variationPoint.setLocation((SoftwareElement)enclosingSoftwareElement);
        }
        Variant integrationVariant = this.createVariant(newElement, false, this.variantIDIntegration);
        variationPoint.getVariants().add((Object)integrationVariant);
        return variationPoint;
    }

    private VariationPoint createVariationPointDelete(Commentable element, Commentable enclosingCommentable) {
        JaMoPPJavaSoftwareElement enclosingSoftwareElement = this.createSoftwareElement(enclosingCommentable);
        VariationPoint variationPoint = variabilityFactory.eINSTANCE.createVariationPoint();
        variationPoint.setLocation((SoftwareElement)enclosingSoftwareElement);
        Variant leadingVariant = this.createVariant(element, true, this.variantIDLeading);
        variationPoint.getVariants().add((Object)leadingVariant);
        return variationPoint;
    }

    private VariationPoint createVariationPointChange(EObject changedElement, Commentable parent) {
        Match match = this.comparison.getMatch(changedElement);
        Commentable commentableLeft = (Commentable)match.getLeft();
        Commentable commentableRight = (Commentable)match.getRight();
        return this.createVariationPointChange(commentableLeft, commentableRight, parent);
    }

    private VariationPoint createVariationPointChange(Commentable commentableLeft, Commentable commentableRight, Commentable parent) {
        JaMoPPJavaSoftwareElement enclosingSoftwareElement = this.createSoftwareElement(parent);
        VariationPoint variationPoint = variabilityFactory.eINSTANCE.createVariationPoint();
        variationPoint.setLocation((SoftwareElement)enclosingSoftwareElement);
        Variant integrationVariant = this.createVariant(commentableLeft, false, this.variantIDIntegration);
        variationPoint.getVariants().add((Object)integrationVariant);
        Variant leadingVariant = this.createVariant(commentableRight, true, this.variantIDLeading);
        variationPoint.getVariants().add((Object)leadingVariant);
        return variationPoint;
    }

    private Commentable getParentNode(Commentable commentable) {
        if (commentable instanceof CompilationUnit) {
            return commentable;
        }
        Match parentMatch = this.comparison.getMatch(commentable.eContainer());
        EObject parent = null;
        parent = parentMatch.getRight() != null ? parentMatch.getRight() : parentMatch.getLeft();
        if (parent instanceof Block && parent.eContainer() instanceof Method) {
            return (Commentable)parent.eContainer();
        }
        if (parent instanceof Commentable) {
            return (Commentable)parent;
        }
        this.logger.warn((Object)("Diff with a non-Commentable parent detected. Diff child: " + commentable));
        return null;
    }

    private Variant createVariant(Commentable commentable, Boolean leading, String variantID) {
        JaMoPPJavaSoftwareElement softwareElement = this.createSoftwareElement(commentable);
        Variant integrationVariant = null;
        integrationVariant = variabilityFactory.eINSTANCE.createVariant();
        integrationVariant.getImplementingElements().add((Object)softwareElement);
        integrationVariant.setLeading(leading);
        integrationVariant.setId(variantID);
        return integrationVariant;
    }

    private JaMoPPJavaSoftwareElement createSoftwareElement(Commentable commentable) {
        if (this.elementRegistry.containsKey(commentable)) {
            return this.elementRegistry.get(commentable);
        }
        JaMoPPSoftwareElement element = softwareFactory.eINSTANCE.createJaMoPPSoftwareElement();
        element.setJamoppElement(commentable);
        this.vpm.getSoftwareElements().add((Object)element);
        this.elementRegistry.put(commentable, (JaMoPPJavaSoftwareElement)element);
        return element;
    }
}

