/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.builder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.ecore.EObject;
import org.splevo.jamopp.diffing.jamoppdiff.JaMoPPDiff;
import org.splevo.jamopp.vpm.builder.JaMoPPDiffVisitor;
import org.splevo.vpm.builder.VPMBuilder;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;
import org.splevo.vpm.variability.variabilityFactory;

public class JaMoPPVPMBuilder
implements VPMBuilder {
    public static final String GROUP_ID_TOPLEVEL = "[TOP LEVEL GROUP]";
    private Logger logger = Logger.getLogger(JaMoPPVPMBuilder.class);

    public VariationPointModel buildVPM(Comparison comparisonModel, String variantIDLeading, String variantIDIntegration) {
        if (!this.diffModelIsValid(comparisonModel)) {
            return null;
        }
        this.improveResourceSetContext(comparisonModel);
        VariationPointModel vpm = variabilityFactory.eINSTANCE.createVariationPointModel();
        JaMoPPDiffVisitor jamoppDiffVisitor = new JaMoPPDiffVisitor(variantIDLeading, variantIDIntegration, vpm, comparisonModel);
        for (Diff diff : comparisonModel.getDifferences()) {
            VariationPoint vp = (VariationPoint)jamoppDiffVisitor.doSwitch((EObject)diff);
            if (vp != null) {
                VariationPointGroup group = this.createGroup(vp);
                vpm.getVariationPointGroups().add((Object)group);
                continue;
            }
            this.logger.warn((Object)("null VariationPoint created: " + diff));
        }
        return vpm;
    }

    private VariationPointGroup createGroup(VariationPoint vp) {
        VariationPointGroup group = variabilityFactory.eINSTANCE.createVariationPointGroup();
        String groupName = this.buildGroupName(vp.getLocation());
        group.setName(groupName);
        group.getVariationPoints().add((Object)vp);
        return group;
    }

    private void improveResourceSetContext(Comparison comparisonModel) {
        if (comparisonModel.eResource() != null && comparisonModel.eResource().getResourceSet() != null) {
            Map loadOptions = comparisonModel.eResource().getResourceSet().getLoadOptions();
            loadOptions.put("DISABLE_LAYOUT_INFORMATION_RECORDING", Boolean.TRUE);
            loadOptions.put("DISABLE_LOCATION_MAP", Boolean.TRUE);
        }
    }

    private String buildGroupName(SoftwareElement softwareElement) {
        if (softwareElement == null) {
            this.logger.warn((Object)"No enclosing element provided to derive group id");
            return GROUP_ID_TOPLEVEL;
        }
        String label = softwareElement.getLabel();
        return this.improveLabel(label);
    }

    private String improveLabel(String label) {
        if (label.endsWith("()")) {
            label = label.substring(0, label.length() - 2);
        } else if (label.lastIndexOf(".") != -1) {
            label = label.substring(0, label.lastIndexOf("."));
        }
        return label;
    }

    private boolean diffModelIsValid(Comparison compareModel) {
        ArrayList differences = Lists.newArrayList((Iterable)compareModel.getDifferences());
        for (Diff diff : differences) {
            if (!(diff instanceof JaMoPPDiff)) continue;
            return true;
        }
        return false;
    }

    public String getId() {
        return this.getClass().getSimpleName();
    }

    public String getLabel() {
        return "JaMoPP VPM Builder";
    }
}

