/*******************************************************************************
 * Copyright (c) 2014
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Benjamin Klatt - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.splevo.jamopp.vpm.software.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Switch;
import org.splevo.jamopp.vpm.software.*;
import org.splevo.vpm.software.JavaSoftwareElement;
import org.splevo.vpm.software.SoftwareElement;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance hierarchy. It supports the
 * call {@link #doSwitch(EObject) doSwitch(object)} to invoke the <code>caseXXX</code> method for
 * each class of the model, starting with the actual class of the object and proceeding up the
 * inheritance hierarchy until a non-null result is returned, which is the result of the switch.
 * <!-- end-user-doc -->
 * 
 * @see org.splevo.jamopp.vpm.software.softwarePackage
 * @generated
 */
public class softwareSwitch<T> extends Switch<T> {
    /**
     * The cached model package <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected static softwarePackage modelPackage;

    /**
     * Creates an instance of the switch. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public softwareSwitch() {
        if (modelPackage == null) {
            modelPackage = softwarePackage.eINSTANCE;
        }
    }

    /**
     * Checks whether this is a switch for the given package. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @parameter ePackage the package in question.
     * @return whether this is a switch for the given package.
     * @generated
     */
    @Override
    protected boolean isSwitchFor(EPackage ePackage) {
        return ePackage == modelPackage;
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result;
     * it yields that result. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    @Override
    protected T doSwitch(int classifierID, EObject theEObject) {
        switch (classifierID) {
        case softwarePackage.JA_MO_PP_SOFTWARE_ELEMENT: {
            JaMoPPSoftwareElement jaMoPPSoftwareElement = (JaMoPPSoftwareElement) theEObject;
            T result = caseJaMoPPSoftwareElement(jaMoPPSoftwareElement);
            if (result == null)
                result = caseJaMoPPJavaSoftwareElement(jaMoPPSoftwareElement);
            if (result == null)
                result = caseJavaSoftwareElement(jaMoPPSoftwareElement);
            if (result == null)
                result = caseSoftwareElement(jaMoPPSoftwareElement);
            if (result == null)
                result = defaultCase(theEObject);
            return result;
        }
        case softwarePackage.COMMENTABLE_SOFTWARE_ELEMENT: {
            CommentableSoftwareElement commentableSoftwareElement = (CommentableSoftwareElement) theEObject;
            T result = caseCommentableSoftwareElement(commentableSoftwareElement);
            if (result == null)
                result = caseJaMoPPJavaSoftwareElement(commentableSoftwareElement);
            if (result == null)
                result = caseJavaSoftwareElement(commentableSoftwareElement);
            if (result == null)
                result = caseSoftwareElement(commentableSoftwareElement);
            if (result == null)
                result = defaultCase(theEObject);
            return result;
        }
        case softwarePackage.JA_MO_PP_JAVA_SOFTWARE_ELEMENT: {
            JaMoPPJavaSoftwareElement jaMoPPJavaSoftwareElement = (JaMoPPJavaSoftwareElement) theEObject;
            T result = caseJaMoPPJavaSoftwareElement(jaMoPPJavaSoftwareElement);
            if (result == null)
                result = caseJavaSoftwareElement(jaMoPPJavaSoftwareElement);
            if (result == null)
                result = caseSoftwareElement(jaMoPPJavaSoftwareElement);
            if (result == null)
                result = defaultCase(theEObject);
            return result;
        }
        default:
            return defaultCase(theEObject);
        }
    }

    /**
     * Returns the result of interpreting the object as an instance of '
     * <em>Ja Mo PP Software Element</em>'. <!-- begin-user-doc --> This implementation returns
     * null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
     * 
     * @param object
     *            the target of the switch.
     * @return the result of interpreting the object as an instance of '
     *         <em>Ja Mo PP Software Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseJaMoPPSoftwareElement(JaMoPPSoftwareElement object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '
     * <em>Commentable Software Element</em>'. <!-- begin-user-doc --> This implementation returns
     * null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
     * 
     * @param object
     *            the target of the switch.
     * @return the result of interpreting the object as an instance of '
     *         <em>Commentable Software Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseCommentableSoftwareElement(CommentableSoftwareElement object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '
     * <em>Ja Mo PP Java Software Element</em>'. <!-- begin-user-doc --> This implementation returns
     * null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
     * 
     * @param object
     *            the target of the switch.
     * @return the result of interpreting the object as an instance of '
     *         <em>Ja Mo PP Java Software Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseJaMoPPJavaSoftwareElement(JaMoPPJavaSoftwareElement object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Element</em>'. <!--
     * begin-user-doc --> This implementation returns null; returning a non-null result will
     * terminate the switch. <!-- end-user-doc -->
     * 
     * @param object
     *            the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSoftwareElement(SoftwareElement object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '
     * <em>Java Software Element</em>'. <!-- begin-user-doc --> This implementation returns null;
     * returning a non-null result will terminate the switch. <!-- end-user-doc -->
     * 
     * @param object
     *            the target of the switch.
     * @return the result of interpreting the object as an instance of '
     *         <em>Java Software Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseJavaSoftwareElement(JavaSoftwareElement object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>EObject</em>'. <!--
     * begin-user-doc --> This implementation returns null; returning a non-null result will
     * terminate the switch, but this is the last case anyway. <!-- end-user-doc -->
     * 
     * @param object
     *            the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
    @Override
    public T defaultCase(EObject object) {
        return null;
    }

} // softwareSwitch
