/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.JaMoPPVPM.software.impl;

import java.io.File;
import org.eclipse.emf.ecore.EObject;
import org.emftext.language.java.classifiers.Class;
import org.emftext.language.java.classifiers.ConcreteClassifier;
import org.emftext.language.java.members.ClassMethod;
import org.emftext.language.java.members.Field;
import org.emftext.language.java.members.Method;
import org.emftext.language.java.statements.Block;
import org.emftext.language.java.statements.LocalVariableStatement;
import org.emftext.language.java.statements.Statement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.splevo.jamopp.JaMoPPVPM.software.impl.JaMoPPJavaSoftwareElementTest;
import org.splevo.jamopp.vpm.software.CommentableSoftwareElement;
import org.splevo.jamopp.vpm.software.softwareFactory;

public class CommentableSoftwareElementImplTest
extends JaMoPPJavaSoftwareElementTest {
    private static final File TEST_FILE = new File("testcode/CommentedExampleClass.java");
    private CommentableSoftwareElement subject;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.subject = softwareFactory.eINSTANCE.createCommentableSoftwareElement();
    }

    @Test
    public void testSetTypeForBlock() {
        this.subject.setType(Block.class);
        Assert.assertEquals(Block.class, (Object)this.subject.getType());
    }

    @Test
    public void testSetTypeForLocalVariableStatement() {
        this.subject.setType(LocalVariableStatement.class);
        Assert.assertEquals(Statement.class, (Object)this.subject.getType());
    }

    @Test
    public void testSetTypeForClass() {
        this.subject.setType(Class.class);
        Assert.assertEquals(Class.class, (Object)this.subject.getType());
    }

    @Test
    public void testSetTypeForMethod() {
        this.subject.setType(Method.class);
        Assert.assertEquals(Method.class, (Object)this.subject.getType());
    }

    @Test
    public void testResolveStatementReference() {
        this.subject.setCompilationUnit(this.compilationUnit);
        this.subject.setId("ID_Statement");
        this.subject.setType(Statement.class);
        Statement expected = (Statement)((ClassMethod)((ConcreteClassifier)this.compilationUnit.getClassifiers().get(0)).getMethods().get(1)).getStatements().get(0);
        EObject actual = this.subject.getWrappedElement();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testResolveMethodReference() {
        this.subject.setCompilationUnit(this.compilationUnit);
        this.subject.setId("ID_Method");
        this.subject.setType(Method.class);
        EObject expected = (EObject)((ConcreteClassifier)this.compilationUnit.getClassifiers().get(0)).getMethods().get(1);
        EObject actual = this.subject.getWrappedElement();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testResolveFieldReference() {
        this.subject.setCompilationUnit(this.compilationUnit);
        this.subject.setId("ID_Field");
        this.subject.setType(Field.class);
        EObject expected = (EObject)((ConcreteClassifier)this.compilationUnit.getClassifiers().get(0)).getFields().get(0);
        EObject actual = this.subject.getWrappedElement();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testResolveInnerClass() {
        this.subject.setCompilationUnit(this.compilationUnit);
        this.subject.setId("ID_INNER_CLASS");
        this.subject.setType(Class.class);
        EObject expected = (EObject)((ClassMethod)((ConcreteClassifier)this.compilationUnit.getClassifiers().get(0)).getMethods().get(0)).getStatements().get(0);
        EObject actual = this.subject.getWrappedElement();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testResolveInnerField() {
        this.subject.setCompilationUnit(this.compilationUnit);
        this.subject.setId("ID_INNER_FIELD");
        this.subject.setType(Field.class);
        EObject expected = (EObject)((ConcreteClassifier)((ClassMethod)((ConcreteClassifier)this.compilationUnit.getClassifiers().get(0)).getMethods().get(0)).getStatements().get(0)).getFields().get(0);
        EObject actual = this.subject.getWrappedElement();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Override
    protected File getTestFile() {
        return TEST_FILE;
    }

    @Override
    protected boolean parseLayoutInformation() {
        return true;
    }
}

