/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.refactoring;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.splevo.refactoring.VariabilityRefactoring;
import org.splevo.refactoring.VariabilityRefactoringRegistry;
import org.splevo.vpm.realization.RealizationFactory;
import org.splevo.vpm.realization.VariabilityMechanism;

public class VariabilityRefactoringRegistryTest {
    @Before
    @After
    public void cleanUp() {
        VariabilityRefactoringRegistry.getInstance().getElements().clear();
    }

    @Test
    public void test() {
        VariabilityMechanism mechanism = RealizationFactory.eINSTANCE.createVariabilityMechanism();
        mechanism.setName("TestMechanism");
        VariabilityRefactoring refactoring = (VariabilityRefactoring)Mockito.mock(VariabilityRefactoring.class);
        Mockito.when((Object)refactoring.getId()).thenReturn((Object)"TESTID");
        Mockito.when((Object)refactoring.getVariabilityMechanism()).thenReturn((Object)mechanism);
        VariabilityRefactoringRegistry.getInstance().registerElement((Object)refactoring);
        List refactorings = VariabilityRefactoringRegistry.getInstance().getElements();
        Assert.assertThat((String)"Wrong number of registered refactorings", (Object)refactorings.size(), (Matcher)CoreMatchers.is((Object)1));
    }
}

