/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.refactoring;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.splevo.refactoring.RecommenderResult;
import org.splevo.refactoring.VariabilityRefactoring;
import org.splevo.refactoring.VariabilityRefactoringService;
import org.splevo.vpm.realization.RealizationFactory;
import org.splevo.vpm.realization.VariabilityMechanism;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;
import org.splevo.vpm.variability.variabilityFactory;

public class VariabilityRefactoringServiceTest {
    @BeforeClass
    public static void setUp() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
    }

    @Test
    public void testRecommendMechanismsAssignesValidMechanism() {
        VariabilityRefactoring refactoring = this.buildRefactoring("REFACTORING1");
        VariabilityRefactoring refactoring2 = this.buildRefactoring("REFACTORING2");
        ArrayList refactorings = Lists.newArrayList((Object[])new VariabilityRefactoring[]{refactoring, refactoring2});
        BasicDiagnostic diagnostic = new BasicDiagnostic(0, null, 0, null, null);
        Mockito.when((Object)refactoring.canBeAppliedTo((VariationPoint)Matchers.notNull(VariationPoint.class))).thenReturn((Object)diagnostic);
        ArrayList mechanisms = Lists.newArrayList((Object[])new VariabilityMechanism[]{null, refactoring2.getVariabilityMechanism()});
        VariationPointModel model = this.crateVPMWithOneGroup(mechanisms);
        VariabilityRefactoringService service = new VariabilityRefactoringService();
        RecommenderResult result = service.recommendMechanisms(model, (List)refactorings);
        this.assertNoUnassignedVP(result);
        this.assertExpectedMechanismsAssigned(model, refactorings);
    }

    @Test
    public void testRecommendMechanismsAssignesNoInvalidMechanism() {
        VariabilityRefactoring refactoring = this.buildRefactoring("REFACTORING1");
        VariabilityRefactoring refactoring2 = this.buildRefactoring("REFACTORING2");
        ArrayList refactorings = Lists.newArrayList((Object[])new VariabilityRefactoring[]{refactoring, refactoring2});
        BasicDiagnostic diagnostic = new BasicDiagnostic(4, null, 0, null, null);
        Mockito.when((Object)refactoring.canBeAppliedTo((VariationPoint)Matchers.notNull(VariationPoint.class))).thenReturn((Object)diagnostic);
        Mockito.when((Object)refactoring2.canBeAppliedTo((VariationPoint)Matchers.notNull(VariationPoint.class))).thenReturn((Object)diagnostic);
        ArrayList mechanisms = Lists.newArrayList((Object[])new VariabilityMechanism[]{null, refactoring2.getVariabilityMechanism()});
        VariationPointModel model = this.crateVPMWithOneGroup(mechanisms);
        VariabilityRefactoringService service = new VariabilityRefactoringService();
        service.recommendMechanisms(model, (List)refactorings);
        this.assertExpectedMechanismsAssigned(model, Lists.newArrayList((Object[])new VariabilityRefactoring[]{null, refactoring2}));
    }

    private VariationPointModel crateVPMWithOneGroup(List<VariabilityMechanism> mechnisms) {
        VariationPointModel model = variabilityFactory.eINSTANCE.createVariationPointModel();
        VariationPointGroup group = variabilityFactory.eINSTANCE.createVariationPointGroup();
        model.getVariationPointGroups().add((Object)group);
        for (VariabilityMechanism mechanism : mechnisms) {
            VariationPoint vp = variabilityFactory.eINSTANCE.createVariationPoint();
            vp.setVariabilityMechanism(mechanism);
            group.getVariationPoints().add((Object)vp);
        }
        return model;
    }

    private void assertExpectedMechanismsAssigned(VariationPointModel model, List<VariabilityRefactoring> refactorings) {
        VariationPointGroup group = (VariationPointGroup)model.getVariationPointGroups().get(0);
        int i = 0;
        while (i < refactorings.size()) {
            VariabilityRefactoring varRef = refactorings.get(i);
            VariationPoint vp = (VariationPoint)group.getVariationPoints().get(i);
            if (varRef == null) {
                Assert.assertThat((Object)vp.getVariabilityMechanism(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
            } else {
                VariabilityMechanism refMechanism = varRef.getVariabilityMechanism();
                VariabilityMechanism vpMechanism = vp.getVariabilityMechanism();
                Assert.assertThat((Object)vpMechanism.getRefactoringID(), (Matcher)CoreMatchers.equalTo((Object)refMechanism.getRefactoringID()));
            }
            ++i;
        }
    }

    private void assertNoUnassignedVP(RecommenderResult result) {
        Assert.assertThat((Object)result.getUnassignedVariationPoints().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    private VariabilityRefactoring buildRefactoring(String refactoringID) {
        VariabilityMechanism mechanism = RealizationFactory.eINSTANCE.createVariabilityMechanism();
        mechanism.setRefactoringID(refactoringID);
        VariabilityRefactoring refactoring = (VariabilityRefactoring)Mockito.mock(VariabilityRefactoring.class);
        Mockito.when((Object)refactoring.getVariabilityMechanism()).thenReturn((Object)mechanism);
        Mockito.when((Object)refactoring.getId()).thenReturn((Object)refactoringID);
        return refactoring;
    }
}

