/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.commons.wizard;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ChangeSingleAttributeWizardPage<T>
extends WizardPage {
    private final ValueConverter<T> converter;
    private final String attributeName;
    private Text newElementTextField;
    private T oldElement;
    private final boolean multilineEditControl;

    public ChangeSingleAttributeWizardPage(String elementTypeName, String attributeName, boolean multilineEdit, ValueConverter<T> converter, T oldElement) {
        super(String.format("%s %s editing page", elementTypeName, attributeName));
        this.setTitle(String.format("%s %s Editing", elementTypeName, StringUtils.capitalize((String)attributeName)));
        this.setDescription(String.format("Enter the new %s for the %s.", attributeName, elementTypeName));
        this.oldElement = oldElement;
        this.converter = converter;
        this.attributeName = attributeName;
        this.multilineEditControl = multilineEdit;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        int labelGridData = 0;
        int editBoxGridData = 768;
        int editBoxStyle = 4;
        if (this.multilineEditControl) {
            editBoxStyle = 2;
            editBoxGridData = 1808;
            labelGridData = 2;
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(editBoxGridData));
        Label nameLabel = new Label(container, 128);
        nameLabel.setLayoutData((Object)new GridData(labelGridData));
        nameLabel.setText(String.format("New %s: ", StringUtils.capitalize((String)this.attributeName)));
        nameLabel.setFont(parent.getFont());
        this.newElementTextField = new Text(container, 0x800 | editBoxStyle);
        GridData data = new GridData(editBoxGridData);
        this.newElementTextField.setLayoutData((Object)data);
        this.newElementTextField.setFont(parent.getFont());
        this.newElementTextField.setText(this.converter.convertFromType(this.oldElement));
        this.newElementTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangeSingleAttributeWizardPage.this.setPageComplete(ChangeSingleAttributeWizardPage.this.isPageComplete());
            }
        });
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    public T getNewElement() {
        return this.converter.convertFromString(this.newElementTextField.getText());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.newElementTextField.setFocus();
        }
    }

    public boolean isPageComplete() {
        T element = this.converter.convertFromString(this.newElementTextField.getText());
        return element != null && this.converter.isValid(element);
    }

    public static interface ValueConverter<T> {
        public T convertFromString(String var1);

        public String convertFromType(T var1);

        public boolean isValid(T var1);
    }
}

