/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.commons.util;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.splevo.ui.commons.util.SingleLevelContentProvider;
import org.splevo.ui.commons.util.SingleLevelElementProvider;

public abstract class ComboBoxSelectionComposite
extends Composite {
    private static final Logger LOGGER = Logger.getLogger(ComboBoxSelectionComposite.class);
    private ComboViewer comboViewer;
    private Button acceptButton;
    private final String explanation;
    private final String buttonLabel;

    protected ComboBoxSelectionComposite(Composite parent, String explanation, String buttonLabel) {
        super(parent, 0);
        this.explanation = explanation;
        this.buttonLabel = buttonLabel;
        this.init();
    }

    private void init() {
        this.setLayoutData(new GridData(1808));
        this.setLayout((Layout)new GridLayout(2, false));
        Label explanationLabel = new Label((Composite)this, 64);
        this.comboViewer = new ComboViewer((Composite)this, 12);
        this.acceptButton = new Button((Composite)this, 0);
        explanationLabel.setText(this.explanation);
        explanationLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.comboViewer.setContentProvider((IContentProvider)new SingleLevelContentProvider());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ComboBoxSelectionComposite.this.acceptButton.setEnabled(true);
            }
        });
        this.comboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.acceptButton.setText(this.buttonLabel);
        this.acceptButton.setEnabled(false);
        this.acceptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!(ComboBoxSelectionComposite.this.comboViewer.getSelection() instanceof IStructuredSelection)) {
                    LOGGER.warn((Object)"No structured selection returned from combo box.");
                    return;
                }
                IStructuredSelection cvSelection = (IStructuredSelection)ComboBoxSelectionComposite.this.comboViewer.getSelection();
                ComboBoxSelectionComposite.this.handleSelectionAfterAccept(cvSelection);
            }
        });
    }

    public void reset() {
        this.comboViewer.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ComboBoxSelectionComposite.this.comboViewer.setInput((Object)ComboBoxSelectionComposite.this.getComboViewerInput());
                ComboBoxSelectionComposite.this.acceptButton.setEnabled(false);
            }
        });
    }

    protected abstract ILabelProvider getLabelProvider();

    protected abstract SingleLevelElementProvider getComboViewerInput();

    protected abstract void handleSelectionAfterAccept(IStructuredSelection var1);
}

