/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.vpexplorer.featureoutline;

import com.google.common.collect.Iterables;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.splevo.ui.commons.tooltip.CustomizableDescriptionHavingTreeViewerToolTip;
import org.splevo.ui.vpexplorer.Activator;
import org.splevo.ui.vpexplorer.explorer.ExplorerMediator;
import org.splevo.ui.vpexplorer.explorer.VPExplorerContent;
import org.splevo.ui.vpexplorer.featureoutline.actions.NoVariabilityMechanismAction;
import org.splevo.ui.vpexplorer.featureoutline.actions.ShowVariantAction;
import org.splevo.ui.vpexplorer.linking.ILinkableNavigator;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointModel;

public class FeatureOutlineView
extends CommonNavigator
implements ILinkableNavigator {
    public static final String VIEW_ID = "org.splevo.ui.vpexplorer.featureoutline";
    private static final String CONTEXT_ID = "org.splevo.ui.vpexplorer.featureoutline.context";
    private ExplorerMediator mediator = Activator.EXPLORER_MEDIATOR;
    private VPExplorerContent vpExplorerContent = new VPExplorerContent(this);

    public FeatureOutlineView() {
        this.mediator.registerVPGroupingExplorer(this);
    }

    protected IAdaptable getInitialInput() {
        this.getCommonViewer().refresh();
        return this.vpExplorerContent;
    }

    public VPExplorerContent getVpExplorerContent() {
        return this.vpExplorerContent;
    }

    public void setVPM(VariationPointModel vpm) {
        this.vpExplorerContent.setVpm(vpm);
    }

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        new CustomizableDescriptionHavingTreeViewerToolTip((TreeViewer)this.getCommonViewer());
        this.getCommonViewer().addSelectionChangedListener((ISelectionChangedListener)this.mediator);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)new NoVariabilityMechanismAction(this));
        toolBar.add((IAction)new ShowVariantAction(this));
        FocusListener focusListener = new FocusListener(){
            private IContextActivation activation;

            public void focusGained(FocusEvent e) {
                this.activation = ((IContextService)PlatformUI.getWorkbench().getService(IContextService.class)).activateContext(FeatureOutlineView.CONTEXT_ID);
            }

            public void focusLost(FocusEvent e) {
                ((IContextService)PlatformUI.getWorkbench().getService(IContextService.class)).deactivateContext(this.activation);
            }
        };
        this.getCommonViewer().getTree().addFocusListener(focusListener);
    }

    public void dispose() {
        this.mediator.deregisterVPGRoupingExplorer();
        super.dispose();
    }

    @Override
    public void elementSelectedInOtherNavigator(Iterable<Object> selectedElements) {
        if (!this.isLinkingEnabled()) {
            return;
        }
        Iterable vps = Iterables.filter(selectedElements, VariationPoint.class);
        ITreeContentProvider contentProvider = this.getNavigatorContentService().createCommonContentProvider();
        ILinkableNavigator.ILinkableNavigatorHelper.expandToObject((TreeViewer)this.getCommonViewer(), contentProvider, vps);
    }
}

