/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.vpexplorer.handler.vpmedit;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;

public class DeleteVariationPointHandler
extends AbstractHandler {
    private static Logger logger = Logger.getLogger(DeleteVariationPointHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        LinkedHashSet resourceToSave = Sets.newLinkedHashSet();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null && selection instanceof IStructuredSelection) {
            Shell activeShell;
            boolean proceed;
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            if (strucSelection.toList().size() > 0 && !(proceed = MessageDialog.openConfirm((Shell)(activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event)), (String)"Delete Variation Point(s)", (String)"Are you sure to delete this variation point(s)?"))) {
                return null;
            }
            for (Object element : strucSelection.toList()) {
                if (!(element instanceof VariationPoint)) continue;
                VariationPoint vp = (VariationPoint)element;
                logger.info((Object)("MANUAL VP DELETE in " + vp.getLocation().getLabel()));
                Resource resource = vp.eResource();
                VariationPointGroup group = vp.getGroup();
                group.getVariationPoints().remove((Object)vp);
                resourceToSave.add(resource);
            }
        }
        for (Resource resource : resourceToSave) {
            try {
                resource.save(null);
            }
            catch (IOException e) {
                throw new ExecutionException("Failed to save modified resource", (Throwable)e);
            }
        }
        return null;
    }
}

