/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.vpexplorer.explorer.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.TreeItem;
import org.splevo.ui.vpexplorer.Activator;
import org.splevo.ui.vpexplorer.explorer.VPExplorer;
import org.splevo.vpm.variability.VariationPoint;

public class ExpandAllAction
extends Action {
    private static final String ICON_FULL = "icons/expandall.gif";
    private static final String ICON_VARIATIONPOINT = "icons/expandall_variationpoint.gif";
    private final VPExplorer explorer;
    private final MODE mode;

    public ExpandAllAction(VPExplorer explorer) {
        this(explorer, MODE.FULL);
    }

    public ExpandAllAction(VPExplorer explorer, MODE mode) {
        super(mode == MODE.VARIATIONPOINT ? "Expand All VariationPoints" : "Expand All", 2);
        this.explorer = explorer;
        this.mode = mode;
        if (mode == MODE.VARIATIONPOINT) {
            this.setToolTipText("Expand up to Variation Points");
            this.setImageDescriptor(Activator.getImageDescriptor(ICON_VARIATIONPOINT));
        } else {
            this.setToolTipText("Expand complete tree");
            this.setImageDescriptor(Activator.getImageDescriptor(ICON_FULL));
        }
    }

    public void run() {
        if (this.mode == MODE.FULL) {
            this.explorer.getCommonViewer().expandAll();
        } else {
            TreeItem[] treeItemArray = this.explorer.getCommonViewer().getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                this.expandTreeItem(item);
                ++n2;
            }
        }
        this.setChecked(false);
        this.explorer.getCommonViewer().refresh();
    }

    private void expandTreeItem(TreeItem item) {
        if (item.getData() instanceof VariationPoint) {
            return;
        }
        item.setExpanded(true);
        this.explorer.getCommonViewer().refresh();
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem subItem = treeItemArray[n2];
            this.expandTreeItem(subItem);
            ++n2;
        }
    }

    public String getId() {
        return "org.splevo.ui.vpexplorer.explorer.actions" + this.mode.toString();
    }

    public static enum MODE {
        FULL,
        VARIATIONPOINT;

    }
}

