/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.vpexplorer.handler.characteristics;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.LinkedHashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.views.properties.PropertySheet;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;

public abstract class AbstractChangeCharacteristicHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        return this.execute(selection);
    }

    public Object execute(ISelection selection) throws ExecutionException {
        LinkedHashSet resourceToSave = Sets.newLinkedHashSet();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            for (Object element : strucSelection.toList()) {
                if (element instanceof VariationPoint) {
                    VariationPoint vp = (VariationPoint)element;
                    if (!this.changeVariationPointCharacteristic(vp)) continue;
                    resourceToSave.add(vp.eResource());
                    continue;
                }
                if (!(element instanceof VariationPointGroup)) continue;
                VariationPointGroup group = (VariationPointGroup)element;
                for (VariationPoint vp : group.getVariationPoints()) {
                    if (!this.changeVariationPointCharacteristic(vp)) continue;
                    resourceToSave.add(vp.eResource());
                }
            }
        }
        for (Resource resource : resourceToSave) {
            try {
                resource.save(null);
            }
            catch (IOException e) {
                throw new ExecutionException("Failed to save modified resource", (Throwable)e);
            }
        }
        this.refreshPropertySheet(selection);
        return null;
    }

    private void refreshPropertySheet(ISelection selection) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart view = page.findView("org.eclipse.ui.views.PropertySheet");
        if (!(view instanceof PropertySheet)) {
            return;
        }
        PropertySheet pSheet = (PropertySheet)view;
        pSheet.selectionChanged(page.getActivePart(), (ISelection)StructuredSelection.EMPTY);
        pSheet.selectionChanged(page.getActivePart(), selection);
    }

    protected abstract boolean changeVariationPointCharacteristic(VariationPoint var1);
}

