/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.vpexplorer.providers;

import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.splevo.ui.commons.util.LabelUtils;
import org.splevo.ui.vpexplorer.explorer.VPExplorerContent;
import org.splevo.ui.vpexplorer.featureoutline.content.VariantWrapper;
import org.splevo.ui.vpexplorer.providers.FileWrapper;
import org.splevo.ui.vpexplorer.providers.VPExplorerContentProvider;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;

public class VPExplorerLabelProvider
extends LabelProvider {
    private static Logger logger = Logger.getLogger(VPExplorerLabelProvider.class);

    public Image getImage(Object element) {
        Image image;
        if (element instanceof File) {
            File file = (File)element;
            return this.getImageForFile(file);
        }
        if (element instanceof VPExplorerContent) {
            return null;
        }
        if (element instanceof FileWrapper) {
            File file = ((FileWrapper)element).getFile();
            return this.getImageForFile(file);
        }
        if (element instanceof VariantWrapper) {
            element = ((VariantWrapper)element).getVariant();
        }
        if ((image = this.getItemProviderImage(element)) != null) {
            return image;
        }
        logger.warn((Object)"Unsupported tree node element");
        return null;
    }

    private Image getImageForFile(File file) {
        if (file.isDirectory()) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (file.getName().endsWith(".java")) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jcu_obj.gif");
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    }

    private Image getItemProviderImage(Object element) {
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)composedAdapterFactory);
        return labelProvider.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof VariationPointGroup) {
            return LabelUtils.getItemProviderText((Object)element);
        }
        if (element instanceof VariationPoint) {
            return LabelUtils.getItemProviderText((Object)element);
        }
        if (element instanceof Variant) {
            return "Variant: " + ((Variant)element).getId();
        }
        if (element instanceof VariantWrapper) {
            return "Variant: " + ((VariantWrapper)element).getVariant().getId();
        }
        if (element instanceof SoftwareElement) {
            return ((SoftwareElement)element).getLabel();
        }
        if (element instanceof File) {
            File file = (File)element;
            String label = file.getName();
            if (label != null && label.length() > 0) {
                int numberOfVPs = VPExplorerContentProvider.getVPInFile(file).size();
                if (numberOfVPs > 0) {
                    return String.format("%s [%s VP]", label, numberOfVPs);
                }
                return label;
            }
            return file.getPath();
        }
        if (element instanceof FileWrapper) {
            File file = ((FileWrapper)element).getFile();
            String label = file.getName();
            if (label != null && label.length() > 0) {
                return label;
            }
            return file.getPath();
        }
        if (element instanceof VPExplorerContent) {
            return null;
        }
        logger.warn((Object)"Unsupported tree node element");
        return null;
    }
}

