/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.vpexplorer.util;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.splevo.project.SPLevoProject;
import org.splevo.project.VPMModelReference;
import org.splevo.ui.commons.util.JobUtil;
import org.splevo.ui.vpexplorer.explorer.VPExplorer;
import org.splevo.ui.vpexplorer.util.SwitchBackVPMJob;
import org.splevo.vpm.VPMUtil;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public final class VPMUIUtil {
    private static Logger logger = Logger.getLogger(VPMUIUtil.class);

    private VPMUIUtil() {
    }

    private static void openVPExplorer(final SPLevoProject splevoProject, final String vpmPath, final boolean loadLayout) {
        Job job = new Job("Open VP Explorer"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Open VPExplorer", -1);
                monitor.subTask("Load Variation Point Model");
                VariationPointModel vpm = VPMUIUtil.loadVPM(splevoProject, vpmPath, loadLayout, monitor);
                if (vpm == null) {
                    return Status.CANCEL_STATUS;
                }
                monitor.subTask("Init VPM Access");
                VPMUIUtil.initVPMAccess(monitor, vpm);
                monitor.subTask("Open View");
                VPMUIUtil.openViewPart(vpm, splevoProject);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public static void openVPExplorer(final SPLevoProject splevoProject, final VariationPointModel vpm) {
        Job job = new Job("Open VP Explorer"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Open VPExplorer", -1);
                monitor.subTask("Init VPM Access");
                VPMUIUtil.initVPMAccess(monitor, vpm);
                monitor.subTask("Open View");
                VPMUIUtil.openViewPart(vpm, splevoProject);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private static void openViewPart(final VariationPointModel vpm, final SPLevoProject splevoProject) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchWindow activeWorkbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IViewPart viewPart = activeWorkbench.getActivePage().showView("org.splevo.ui.vpexplorer");
                    VPExplorer explorer = (VPExplorer)viewPart;
                    explorer.setVPM(vpm, splevoProject);
                    if (splevoProject == null) {
                        logger.warn((Object)"The VPMExplorer is about to be loaded with an invalid (null) SPLevo project.");
                    }
                }
                catch (PartInitException e) {
                    logger.error((Object)"Could not create the VP explorer view", (Throwable)e);
                }
            }
        });
    }

    public static Job switchBackVPMVersion(SPLevoProject splevoProject, VPMModelReference vpmReference) {
        SwitchBackVPMJob switchBackJob = new SwitchBackVPMJob(splevoProject, vpmReference);
        switchBackJob.setUser(true);
        switchBackJob.schedule();
        return switchBackJob;
    }

    private static void initVPMAccess(IProgressMonitor monitor, VariationPointModel vpm) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Init VPM Access", (int)vpm.getVariationPointGroups().size());
        for (VariationPointGroup vpg : vpm.getVariationPointGroups()) {
            if (subMonitor.isCanceled()) {
                subMonitor.done();
                return;
            }
            for (VariationPoint vp : vpg.getVariationPoints()) {
                vp.getLocation().getSourceLocation();
            }
            subMonitor.worked(1);
        }
        subMonitor.done();
    }

    private static VariationPointModel loadVPM(SPLevoProject splevoProject, String vpmPath, boolean loadLayoutInformation, IProgressMonitor monitor) {
        VariationPointModel vpm = null;
        File vpmFile = new File(vpmPath);
        ResourceSet resSet = JobUtil.initResourceSet((SPLevoProject)splevoProject, (boolean)loadLayoutInformation);
        try {
            vpm = VPMUtil.loadVariationPointModel((File)vpmFile, (ResourceSet)resSet);
        }
        catch (IOException ioe) {
            monitor.setCanceled(true);
            VPMUIUtil.showErrorDialog("Failed to open VPM", "An error occured while opening the VPM: " + ioe.getMessage());
            logger.error((Object)"Failed to load variation point model.", (Throwable)ioe);
        }
        return vpm;
    }

    private static void showErrorDialog(final String title, final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public static void openVPExplorer(SPLevoProject splevoProject, VPMModelReference vpmModelReference) {
        VPMUIUtil.openVPExplorer(splevoProject, vpmModelReference.getPath(), vpmModelReference.isRefactoringStarted());
    }
}

