/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.wizard.consolidation.tests;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.splevo.ui.wizard.consolidation.listener.PackagesCheckStateListener;
import org.splevo.ui.wizard.consolidation.util.PackagesComparator;

public class PackagesCheckStateListenerTest {
    @Test
    public void testSubtreeCheckState() {
        PackagesCheckStateListener packagesCheckStateListener = new PackagesCheckStateListener();
        IPackageFragment parentPackage = (IPackageFragment)Mockito.mock(IPackageFragment.class);
        Mockito.when((Object)parentPackage.getElementName()).thenReturn((Object)"org.splevo");
        IPackageFragment subPackage1 = (IPackageFragment)Mockito.mock(IPackageFragment.class);
        Mockito.when((Object)subPackage1.getElementName()).thenReturn((Object)"org.splevo.wizard");
        IPackageFragment subPackage2 = (IPackageFragment)Mockito.mock(IPackageFragment.class);
        Mockito.when((Object)subPackage2.getElementName()).thenReturn((Object)"org.splevo.test");
        SortedSet javaPackages = (SortedSet)Mockito.mock(SortedSet.class);
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when(javaPackages.iterator()).thenReturn((Object)iterator);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)((IPackageFragment)iterator.next())).thenReturn((Object)parentPackage, (Object[])new IPackageFragment[]{subPackage1, subPackage2});
        packagesCheckStateListener.setJavaPackages(javaPackages);
        CheckStateChangedEvent checkStateChangedEvent = (CheckStateChangedEvent)Mockito.mock(CheckStateChangedEvent.class);
        CheckboxTreeViewer packagesTreeViewer = (CheckboxTreeViewer)Mockito.mock(CheckboxTreeViewer.class);
        Mockito.when((Object)checkStateChangedEvent.getSource()).thenReturn((Object)packagesTreeViewer);
        Mockito.when((Object)checkStateChangedEvent.getElement()).thenReturn((Object)parentPackage);
        Mockito.when((Object)checkStateChangedEvent.getChecked()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        packagesCheckStateListener.checkStateChanged(checkStateChangedEvent);
        ((CheckboxTreeViewer)Mockito.verify((Object)packagesTreeViewer)).setSubtreeChecked((Object)parentPackage, true);
        packagesCheckStateListener.checkStateChanged(checkStateChangedEvent);
        ((CheckboxTreeViewer)Mockito.verify((Object)packagesTreeViewer)).setSubtreeChecked((Object)parentPackage, false);
    }

    @Test
    public void testParentsCheckState() {
        PackagesCheckStateListener packagesCheckStateListener = new PackagesCheckStateListener();
        IPackageFragment parentPackage = (IPackageFragment)Mockito.mock(IPackageFragment.class);
        Mockito.when((Object)parentPackage.getElementName()).thenReturn((Object)"org.splevo");
        IPackageFragment subPackage1 = (IPackageFragment)Mockito.mock(IPackageFragment.class);
        Mockito.when((Object)subPackage1.getElementName()).thenReturn((Object)"org.splevo.wizard");
        IPackageFragment subPackage2 = (IPackageFragment)Mockito.mock(IPackageFragment.class);
        Mockito.when((Object)subPackage2.getElementName()).thenReturn((Object)"org.splevo.test");
        PackagesComparator comparator = (PackagesComparator)Mockito.mock(PackagesComparator.class);
        Mockito.when((Object)comparator.compare(subPackage2, subPackage1)).thenReturn((Object)2);
        Mockito.when((Object)comparator.compare(subPackage2, parentPackage)).thenReturn((Object)2);
        Mockito.when((Object)comparator.compare(subPackage1, parentPackage)).thenReturn((Object)2);
        TreeSet<IPackageFragment> javaPackages = new TreeSet<IPackageFragment>((Comparator<IPackageFragment>)comparator);
        javaPackages.add(parentPackage);
        javaPackages.add(subPackage1);
        javaPackages.add(subPackage2);
        packagesCheckStateListener.setJavaPackages(javaPackages);
        CheckStateChangedEvent checkStateChangedEvent = (CheckStateChangedEvent)Mockito.mock(CheckStateChangedEvent.class);
        CheckboxTreeViewer packagesTreeViewer = (CheckboxTreeViewer)Mockito.mock(CheckboxTreeViewer.class);
        Mockito.when((Object)checkStateChangedEvent.getSource()).thenReturn((Object)packagesTreeViewer);
        Mockito.when((Object)checkStateChangedEvent.getElement()).thenReturn((Object)subPackage1);
        Mockito.when((Object)packagesTreeViewer.getChecked((Object)subPackage1)).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)packagesTreeViewer.getChecked((Object)subPackage2)).thenReturn((Object)true, (Object[])new Boolean[]{false, false});
        InOrder order = Mockito.inOrder((Object[])new Object[]{packagesTreeViewer});
        packagesCheckStateListener.checkStateChanged(checkStateChangedEvent);
        ((CheckboxTreeViewer)order.verify((Object)packagesTreeViewer)).setGrayed((Object)parentPackage, false);
        ((CheckboxTreeViewer)order.verify((Object)packagesTreeViewer)).setChecked((Object)parentPackage, true);
        packagesCheckStateListener.checkStateChanged(checkStateChangedEvent);
        ((CheckboxTreeViewer)order.verify((Object)packagesTreeViewer)).setChecked((Object)parentPackage, true);
        ((CheckboxTreeViewer)order.verify((Object)packagesTreeViewer)).setGrayed((Object)parentPackage, true);
        packagesCheckStateListener.checkStateChanged(checkStateChangedEvent);
        ((CheckboxTreeViewer)order.verify((Object)packagesTreeViewer)).setChecked((Object)parentPackage, false);
        ((CheckboxTreeViewer)order.verify((Object)packagesTreeViewer)).setGrayed((Object)parentPackage, false);
    }
}

