/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.wizard.consolidation;

import java.util.List;
import java.util.SortedSet;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.wizard.consolidation.listener.PackagesCheckStateListener;
import org.splevo.ui.wizard.consolidation.provider.PackageLabelProvider;
import org.splevo.ui.wizard.consolidation.provider.PackagesTreeContentProvider;
import org.splevo.ui.wizard.consolidation.util.PackageUtil;

public class PackageScopeDefinitionWizardPage
extends WizardPage {
    private SPLevoProject projectConfiguration;
    private CheckboxTreeViewer packagesTreeViewer;
    private SortedSet<IPackageFragment> javaPackages;
    private PackagesTreeContentProvider packagesTreeContentProvider;
    private PackagesCheckStateListener packagesCheckStateListener;

    public PackageScopeDefinitionWizardPage(SPLevoProject projectConfiguration) {
        super("Package Scope Definition Page");
        this.setTitle("Package Scope Definition");
        this.setDescription("Select java packages which you want to be ignored.");
        this.projectConfiguration = projectConfiguration;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.javaPackages = PackageUtil.getJavaPackages(this.projectConfiguration);
            this.packagesTreeContentProvider.setJavaPackages(this.javaPackages);
            this.packagesCheckStateListener.setJavaPackages(this.javaPackages);
            List<IPackageFragment> list = PackageUtil.getRootpackages(this.packagesTreeContentProvider, this.javaPackages);
            this.packagesTreeViewer.setInput((Object)list.toArray(new IPackageFragment[list.size()]));
        }
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 15;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("Select java packages to be ignored:");
        this.createPackagesTreeViewer(container);
        this.setControl((Control)container);
    }

    private void createPackagesTreeViewer(Composite container) {
        this.packagesTreeViewer = new CheckboxTreeViewer(container);
        this.packagesTreeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.packagesTreeViewer.setLabelProvider((IBaseLabelProvider)new PackageLabelProvider());
        this.packagesTreeContentProvider = new PackagesTreeContentProvider();
        this.packagesTreeViewer.setContentProvider((IContentProvider)this.packagesTreeContentProvider);
        this.packagesCheckStateListener = new PackagesCheckStateListener();
        this.packagesTreeViewer.addCheckStateListener((ICheckStateListener)this.packagesCheckStateListener);
    }

    public void saveChosenPackages() {
        Object[] checkedPackages = this.packagesTreeViewer.getCheckedElements();
        String packagesString = "";
        if (checkedPackages.length > 0) {
            int i = 0;
            while (i < checkedPackages.length) {
                if (!this.packagesTreeViewer.getGrayed(checkedPackages[i])) {
                    List<IPackageFragment> subPackages = this.packagesCheckStateListener.getAllSubPackages((IPackageFragment)checkedPackages[i]);
                    if (subPackages.size() > 0) {
                        packagesString = packagesString.concat(String.valueOf(((IPackageFragment)checkedPackages[i]).getElementName()) + ".*\n");
                        i += subPackages.size();
                    } else {
                        packagesString = packagesString.concat(String.valueOf(((IPackageFragment)checkedPackages[i]).getElementName()) + "\n");
                    }
                }
                ++i;
            }
            this.projectConfiguration.getDifferOptions().put((Object)"JaMoPP.Java.Packages.to.ignore", (Object)packagesString.trim());
        }
    }
}

