/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.wizard.consolidation.util;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.wizard.consolidation.provider.PackagesTreeContentProvider;
import org.splevo.ui.wizard.consolidation.util.PackagesComparator;

public class PackageUtil {
    public static List<IProject> getAllChosenProjects(SPLevoProject projectConfiguration) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        ArrayList<IProject> allChosenProjects = new ArrayList<IProject>();
        for (String chosenProjectName : projectConfiguration.getLeadingProjects()) {
            allChosenProjects.add(root.getProject(chosenProjectName));
        }
        for (String chosenProjectName : projectConfiguration.getIntegrationProjects()) {
            allChosenProjects.add(root.getProject(chosenProjectName));
        }
        return allChosenProjects;
    }

    public static List<IPackageFragment> getRootpackages(PackagesTreeContentProvider packagesTreeContentProvider, SortedSet<IPackageFragment> javaPackages) {
        ArrayList<IPackageFragment> rootPackages = new ArrayList<IPackageFragment>();
        for (IPackageFragment javaPackage : javaPackages) {
            if (packagesTreeContentProvider.getParentPackage(javaPackage) != null) continue;
            rootPackages.add(javaPackage);
        }
        return rootPackages;
    }

    public static SortedSet<IPackageFragment> getJavaPackages(SPLevoProject projectConfiguration) {
        TreeSet<IPackageFragment> javaPackagesSet = new TreeSet<IPackageFragment>(new PackagesComparator());
        for (IProject project : PackageUtil.getAllChosenProjects(projectConfiguration)) {
            try {
                if (!project.isNatureEnabled("org.eclipse.jdt.core.javanature")) continue;
                IPackageFragment[] iPackageFragmentArray = JavaCore.create((IProject)project).getPackageFragments();
                int n = iPackageFragmentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragment packageFragment = iPackageFragmentArray[n2];
                    if (!packageFragment.getElementName().equals("")) {
                        javaPackagesSet.add(packageFragment);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return javaPackagesSet;
    }

    public static String getName(IPackageFragment packageFragment) {
        return packageFragment != null ? packageFragment.getElementName() : "";
    }
}

