/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.editors;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.splevo.project.SPLevoProject;
import org.splevo.project.SPLevoProjectUtil;
import org.splevo.ui.SPLevoUIPlugin;
import org.splevo.ui.dashboard.ConfigurationTab;
import org.splevo.ui.dashboard.ProcessControlTab;
import org.splevo.ui.dashboard.ProjectSelectionTab;
import org.splevo.ui.dashboard.SPLProfileTab;

public class SPLevoProjectEditor
extends EditorPart {
    public static final String ID = "org.splevo.ui.editors.SPLevoProjectEditor";
    public static final int TABINDEX_PROCESS_CONTROL = 0;
    public static final int TABINDEX_PROJECT_SELECTION = 1;
    public static final int TABINDEX_CONFIGURATION = 2;
    public static final int TABINDEX_SPL_PROFILE = 3;
    private SPLevoProject splevoProject = null;
    private ProcessControlTab processControlTab;
    private boolean dirtyFlag = false;

    public SPLevoProjectEditor() {
        this.setTitleImage(ResourceManager.getPluginImage("org.splevo.ui", "icons/splevo.gif"));
    }

    public void createPartControl(Composite parent) {
        parent.setBackground(SWTResourceManager.getColor(1));
        GridLayout glParent = new GridLayout(1, false);
        glParent.verticalSpacing = 0;
        glParent.marginWidth = 0;
        glParent.marginHeight = 0;
        glParent.horizontalSpacing = 0;
        parent.setLayout((Layout)glParent);
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setBackground(SWTResourceManager.getColor(1));
        GridData gdTabFolder = new GridData(4, 4, true, true, 1, 1);
        gdTabFolder.widthHint = 837;
        gdTabFolder.heightHint = 353;
        tabFolder.setLayoutData((Object)gdTabFolder);
        this.processControlTab = new ProcessControlTab(this, tabFolder, 0);
        ProjectSelectionTab projectSelectionTab = new ProjectSelectionTab(this, tabFolder, 1);
        new ConfigurationTab(this, tabFolder, 2);
        new SPLProfileTab(this, tabFolder, 3);
        projectSelectionTab.initDataBindings();
        this.processControlTab.enableButtonsIfInformationAvailable();
    }

    public void setFocus() {
    }

    public IFileEditorInput getEditorInput() {
        if (super.getEditorInput() instanceof IFileEditorInput) {
            return (IFileEditorInput)super.getEditorInput();
        }
        return null;
    }

    public void doSave(IProgressMonitor monitor) {
        Shell shell = this.getEditorSite().getShell();
        if (this.getSplevoProject().getWorkspace() == null || this.getSplevoProject().getWorkspace().equals("")) {
            MessageDialog.openError((Shell)shell, (String)"Workspace Missing", (String)"You need to specify a workspace directory for the project.");
            return;
        }
        File filePath = this.getCurrentFilePath();
        try {
            SPLevoProjectUtil.save((SPLevoProject)this.splevoProject, (File)filePath);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)shell, (String)"Save error", (String)("Unable to save the project file to " + filePath));
            e.printStackTrace();
        }
        this.dirtyFlag = false;
        this.firePropertyChange(257);
    }

    private File getCurrentFilePath() {
        FileEditorInput fileInput = (FileEditorInput)this.getEditorInput();
        String filePath = fileInput.getFile().getFullPath().toOSString();
        return new File(filePath);
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IFileEditorInput fileInput;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof IFileEditorInput && (fileInput = (IFileEditorInput)input).getName().endsWith("splevoproject")) {
            File projectFile = new File(fileInput.getFile().getFullPath().toString());
            try {
                this.splevoProject = SPLevoProjectUtil.loadSPLevoProjectModel((File)projectFile);
            }
            catch (Exception e) {
                throw new PartInitException("Unable to load SPLevo project file in editor", (Throwable)e);
            }
        }
    }

    public SPLevoProject getSplevoProject() {
        return this.splevoProject;
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void markAsDirty() {
        this.dirtyFlag = true;
        this.firePropertyChange(257);
    }

    public void updateUI(String message) {
        this.updateUI();
        if (message != null) {
            Shell shell = this.getEditorSite().getShell();
            MessageDialog.openInformation((Shell)shell, (String)"SPLevo Info", (String)message);
        }
    }

    public void updateUI() {
        this.markAsDirty();
        this.doSave((IProgressMonitor)new NullProgressMonitor());
        this.processControlTab.enableButtonsIfInformationAvailable();
    }

    public Image getTitleImage() {
        return SPLevoUIPlugin.KOPL_ICON;
    }
}

