/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.editors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.splevo.ui.editors.UnifiedDiffEditor;
import org.splevo.ui.editors.UnifiedDiffEditorInput;
import org.splevo.ui.sourceconnection.UnifiedDiffConnectorModel;
import org.splevo.ui.util.UIConstants;

public class UnifiedDiffHighlighter {
    private static final Logger LOGGER = Logger.getLogger(UnifiedDiffHighlighter.class);
    private final UnifiedDiffEditor editor;
    private final UnifiedDiffEditorInput editorInput;
    private Map<UnifiedDiffConnectorModel.MarkerType, IGetMarkerColor> markerTypeToGetMarkerColor;

    public UnifiedDiffHighlighter(UnifiedDiffEditor editor) {
        this.editor = editor;
        this.editorInput = (UnifiedDiffEditorInput)editor.getEditorInput();
        this.initializeMarkerMapping();
    }

    private void initializeMarkerMapping() {
        this.markerTypeToGetMarkerColor = new HashMap<UnifiedDiffConnectorModel.MarkerType, IGetMarkerColor>();
        this.markerTypeToGetMarkerColor.put(UnifiedDiffConnectorModel.MarkerType.LEADING_DARK, new GetLeadingDarkColor());
        this.markerTypeToGetMarkerColor.put(UnifiedDiffConnectorModel.MarkerType.LEADING_LIGHT, new GetLeadingLightColor());
        this.markerTypeToGetMarkerColor.put(UnifiedDiffConnectorModel.MarkerType.INTEGRATION1_DARK, new GetIntegration1DarkColor());
        this.markerTypeToGetMarkerColor.put(UnifiedDiffConnectorModel.MarkerType.INTEGRATION1_LIGHT, new GetIntegration1LightColor());
        this.markerTypeToGetMarkerColor.put(UnifiedDiffConnectorModel.MarkerType.INTEGRATION2_DARK, new GetIntegration2DarkColor());
        this.markerTypeToGetMarkerColor.put(UnifiedDiffConnectorModel.MarkerType.INTEGRATION2_LIGHT, new GetIntegration2LightColor());
        this.markerTypeToGetMarkerColor.put(UnifiedDiffConnectorModel.MarkerType.INTEGRATION3_DARK, new GetIntegration3DarkColor());
        this.markerTypeToGetMarkerColor.put(UnifiedDiffConnectorModel.MarkerType.INTEGRATION3_LIGHT, new GetIntegration3LightColor());
        this.markerTypeToGetMarkerColor.put(UnifiedDiffConnectorModel.MarkerType.MIXED_DARK, new GetMixedDarkColor());
        this.markerTypeToGetMarkerColor.put(UnifiedDiffConnectorModel.MarkerType.MIXED_LIGHT, new GetMixedLightColor());
    }

    public Map<Integer, Color> highlightLines() {
        UnifiedDiffConnectorModel diffModel = this.editorInput.getDiffConnectorModel();
        HashMap<Integer, Color> colorToUnifiedLinesMapping = new HashMap<Integer, Color>();
        MarkerAnnotationPreferences maPrefs = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        List aPrefs = maPrefs.getAnnotationPreferences();
        IFile ressource = (IFile)this.editorInput.getAdapter(IFile.class);
        int offset = 0;
        int lineCount = this.editor.getViewer().getTextWidget().getLineCount();
        int lineTextLength = 0;
        String lineText = "";
        int line = 0;
        while (line < lineCount - 1) {
            lineText = this.editor.getViewer().getTextWidget().getLine(line);
            lineTextLength = lineText.length();
            UnifiedDiffConnectorModel.MarkerType markerType = diffModel.getMarkerTypeFor(line);
            if (markerType != UnifiedDiffConnectorModel.MarkerType.NONE) {
                try {
                    IMarker marker = ressource.createMarker("org.splevo.ui.markers.unifieddiff");
                    TextSelection selection = new TextSelection(offset, lineTextLength);
                    this.createAnnotation(marker, (ITextSelection)selection, (ITextEditor)this.editor, markerType);
                }
                catch (CoreException exception) {
                    LOGGER.error((Object)"An error occurred while creating a marker or setting an attribute for said marker!", (Throwable)exception);
                }
                IGetMarkerColor getMarkerColor = this.markerTypeToGetMarkerColor.get((Object)markerType);
                colorToUnifiedLinesMapping.put(line, getMarkerColor.get(aPrefs));
            }
            offset += lineTextLength + 1;
            ++line;
        }
        return colorToUnifiedLinesMapping;
    }

    private void createAnnotation(IMarker marker, ITextSelection selection, ITextEditor editor, UnifiedDiffConnectorModel.MarkerType markerType) {
        IDocumentProvider idp = editor.getDocumentProvider();
        IDocument document = idp.getDocument((Object)this.editorInput);
        IAnnotationModel annotationModel = idp.getAnnotationModel((Object)this.editorInput);
        String annotationType = UIConstants.ANNOTATION_TO_ID.get((Object)markerType);
        SimpleMarkerAnnotation annotation = new SimpleMarkerAnnotation(annotationType, marker);
        annotationModel.connect(document);
        annotationModel.addAnnotation((Annotation)annotation, new Position(selection.getOffset(), selection.getLength()));
        annotationModel.disconnect(document);
    }

    private Color getColorValueFor(String colorKey, List<AnnotationPreference> annotationPreferences) {
        for (AnnotationPreference aPref : annotationPreferences) {
            if (!colorKey.equals(aPref.getColorPreferenceKey())) continue;
            RGB rgb = aPref.getColorPreferenceValue();
            return new Color((Device)Display.getCurrent(), rgb.red, rgb.green, rgb.blue);
        }
        return null;
    }

    public class GetIntegration1DarkColor
    implements IGetMarkerColor {
        @Override
        public Color get(List<AnnotationPreference> annotationPreferences) {
            return UnifiedDiffHighlighter.this.getColorValueFor("integration1DarkAnnotation.color", annotationPreferences);
        }
    }

    public class GetIntegration1LightColor
    implements IGetMarkerColor {
        @Override
        public Color get(List<AnnotationPreference> annotationPreferences) {
            return UnifiedDiffHighlighter.this.getColorValueFor("integration1LightAnnotation.color", annotationPreferences);
        }
    }

    public class GetIntegration2DarkColor
    implements IGetMarkerColor {
        @Override
        public Color get(List<AnnotationPreference> annotationPreferences) {
            return UnifiedDiffHighlighter.this.getColorValueFor("integration2DarkAnnotation.color", annotationPreferences);
        }
    }

    public class GetIntegration2LightColor
    implements IGetMarkerColor {
        @Override
        public Color get(List<AnnotationPreference> annotationPreferences) {
            return UnifiedDiffHighlighter.this.getColorValueFor("integration2LightAnnotation.color", annotationPreferences);
        }
    }

    public class GetIntegration3DarkColor
    implements IGetMarkerColor {
        @Override
        public Color get(List<AnnotationPreference> annotationPreferences) {
            return UnifiedDiffHighlighter.this.getColorValueFor("integration3DarkAnnotation.color", annotationPreferences);
        }
    }

    public class GetIntegration3LightColor
    implements IGetMarkerColor {
        @Override
        public Color get(List<AnnotationPreference> annotationPreferences) {
            return UnifiedDiffHighlighter.this.getColorValueFor("integration3LightAnnotation.color", annotationPreferences);
        }
    }

    public class GetLeadingDarkColor
    implements IGetMarkerColor {
        @Override
        public Color get(List<AnnotationPreference> annotationPreferences) {
            return UnifiedDiffHighlighter.this.getColorValueFor("leadingDarkAnnotation.color", annotationPreferences);
        }
    }

    public class GetLeadingLightColor
    implements IGetMarkerColor {
        @Override
        public Color get(List<AnnotationPreference> annotationPreferences) {
            return UnifiedDiffHighlighter.this.getColorValueFor("leadingLightAnnotation.color", annotationPreferences);
        }
    }

    public class GetMixedDarkColor
    implements IGetMarkerColor {
        @Override
        public Color get(List<AnnotationPreference> annotationPreferences) {
            return UnifiedDiffHighlighter.this.getColorValueFor("mixedDarkAnnotation.color", annotationPreferences);
        }
    }

    public class GetMixedLightColor
    implements IGetMarkerColor {
        @Override
        public Color get(List<AnnotationPreference> annotationPreferences) {
            return UnifiedDiffHighlighter.this.getColorValueFor("mixedLightAnnotation.color", annotationPreferences);
        }
    }

    public static interface ICreateMarkerMethod {
        public IMarker create(IFile var1) throws CoreException;
    }

    public static interface IGetMarkerColor {
        public Color get(List<AnnotationPreference> var1);
    }
}

