/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.handler;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.editors.SPLevoProjectEditor;

public class CleanProjectHandler
extends AbstractHandler {
    private Logger logger = Logger.getLogger(CleanProjectHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(activeEditor instanceof SPLevoProjectEditor)) {
            return null;
        }
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        boolean proceed = MessageDialog.openConfirm((Shell)activeShell, (String)"Clean Project", (String)"Deletes the \"models\" and \"logs\" directories.\nThe Project Selection, Project Infos, Extractor Selection\nand Diffing Package Filter Rules wont be removed.\n\nProceed anyway?");
        if (!proceed) {
            return null;
        }
        SPLevoProjectEditor splevoProjectEditor = (SPLevoProjectEditor)activeEditor;
        SPLevoProject project = splevoProjectEditor.getSplevoProject();
        this.cleanProjetcFiles(project);
        this.cleanProjectMetadata(project);
        splevoProjectEditor.updateUI("Project cleaned.");
        return null;
    }

    private void cleanProjetcFiles(SPLevoProject project) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath workSpacePath = root.getFullPath().append(project.getWorkspace());
        IPath modelsPath = workSpacePath.append("/models");
        IPath logsPath = workSpacePath.append("/logs");
        IResource modelsResource = root.findMember(modelsPath);
        IResource logsResource = root.findMember(logsPath);
        try {
            if (modelsResource != null) {
                modelsResource.delete(true, null);
            }
        }
        catch (CoreException e) {
            this.logger.error((Object)"Cannot delete models folder.", (Throwable)e);
        }
        try {
            if (logsResource != null) {
                logsResource.delete(true, null);
            }
        }
        catch (CoreException e) {
            this.logger.error((Object)"Cannot delete logs folder.", (Throwable)e);
        }
    }

    private void cleanProjectMetadata(SPLevoProject project) {
        project.setDiffingModelPath(null);
        project.setSourceModelPathIntegration(null);
        project.setSourceModelPathLeading(null);
        project.getVpmModelReferences().clear();
    }
}

