/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.handler.vpm;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public class CombineGroupsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection curSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (curSelection != null && curSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)curSelection;
            LinkedHashSet groupsToMerge = Sets.newLinkedHashSet();
            for (Object selectedItem : selection.toList()) {
                if (!(selectedItem instanceof VariationPointGroup)) continue;
                groupsToMerge.add((VariationPointGroup)selectedItem);
            }
            this.combineGroups(groupsToMerge);
        }
        return null;
    }

    private void combineGroups(Set<VariationPointGroup> groupsToMerge) throws ExecutionException {
        LinkedHashSet resourcesToSave = Sets.newLinkedHashSet();
        VariationPointGroup survivingGroup = groupsToMerge.iterator().next();
        VariationPointModel vpm = survivingGroup.getModel();
        for (VariationPointGroup vpg : groupsToMerge) {
            resourcesToSave.add(vpg.eResource());
            this.combineGroup(survivingGroup, vpg, vpm);
        }
        this.updateResources(resourcesToSave);
    }

    private void updateResources(Set<Resource> resourcesToSave) throws ExecutionException {
        for (Resource resource : resourcesToSave) {
            try {
                resource.save(null);
            }
            catch (IOException e) {
                throw new ExecutionException("Failed to save modified resource", (Throwable)e);
            }
        }
    }

    private void combineGroup(VariationPointGroup survivingGroup, VariationPointGroup vpg, VariationPointModel vpm) {
        if (!vpg.equals(survivingGroup)) {
            survivingGroup.getVariationPoints().addAll((Collection)vpg.getVariationPoints());
            vpm.getVariationPointGroups().remove((Object)vpg);
        }
    }
}

