/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.ui.views.vpmgraph.VPMGraphView;
import org.splevo.vpm.analyzer.graph.VPMGraph;

public class OpenVPMGraphJob
extends AbstractBlackboardInteractingJob<SPLevoBlackBoard> {
    public void execute(IProgressMonitor monitor) throws JobFailedException {
        IViewPart viewPart;
        VPMGraph graph = ((SPLevoBlackBoard)this.getBlackboard()).getVpmGraph();
        if (graph == null) {
            this.logger.error((Object)"No VPMGraph loaded in blackboard.");
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)"VPMGraph not available", (String)"No Variation Point Graph detected in the SPLevo blackboard");
            throw new JobFailedException("Editor could not be opened", (Throwable)new NullPointerException("No VPM Graph in blackboard"));
        }
        try {
            viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.splevo.ui.viewer.vpmgraph.VPMGraphViewer", "vpmgraph" + graph.getId(), 1);
        }
        catch (PartInitException e) {
            throw new JobFailedException("Unable to open VPM Graph view.", (Throwable)e);
        }
        final VPMGraphView view = (VPMGraphView)viewPart;
        view.showGraph(graph);
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                activePage.hideView((IViewPart)view);
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        });
    }

    public String getName() {
        return "Open VPM Refinement Browser Job";
    }

    public void cleanup(IProgressMonitor arg0) {
    }
}

