/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import com.google.common.collect.Maps;
import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.splevo.project.SPLevoProject;
import org.splevo.refactoring.VariabilityRefactoringService;
import org.splevo.ui.jobs.ProjectPathUtil;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.vpm.variability.VariationPointModel;

public class RefactorVPMJob
extends AbstractBlackboardInteractingJob<SPLevoBlackBoard> {
    private SPLevoProject splevoProject;

    public RefactorVPMJob(SPLevoProject splevoProject) {
        this.splevoProject = splevoProject;
    }

    public void cleanup(IProgressMonitor arg0) throws CleanupFailedException {
    }

    public void execute(IProgressMonitor arg0) throws JobFailedException, UserCanceledException {
        VariationPointModel vpm = ((SPLevoBlackBoard)this.getBlackboard()).getVariationPointModel();
        String leadingSrcPath = new File(this.getLeadingSrcPath()).getAbsolutePath();
        HashMap refactoringConfigurations = Maps.newHashMap();
        refactoringConfigurations.put("JaMoPP.Refactoring.Options.SourceDirectory", leadingSrcPath);
        VariabilityRefactoringService variabilityRefactoringService = new VariabilityRefactoringService();
        variabilityRefactoringService.refactor(vpm, (Map)refactoringConfigurations);
    }

    private String getLeadingSrcPath() {
        String leadingSrcPath = (String)this.splevoProject.getLeadingProjects().get(0);
        return String.valueOf(ProjectPathUtil.buildProjectPath(leadingSrcPath)) + File.separator + "src";
    }

    public String getName() {
        return "Refactor VPM Model Job";
    }
}

