/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.jobs.LoadVPMJob;
import org.splevo.ui.jobs.OpenVPMJob;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.ui.jobs.SaveVPMJob;

public class SaveAndReloadVPMJob
extends SequentialBlackboardInteractingJob<SPLevoBlackBoard> {
    public SaveAndReloadVPMJob(SPLevoProject splevoProject, String pathSegment, boolean refactoringStarted) {
        this.addJobs(splevoProject, SaveAndReloadVPMJob.getTargetPath(splevoProject, pathSegment), refactoringStarted);
    }

    private void addJobs(SPLevoProject splevoProject, String targetPath, boolean refactoringStarted) {
        LoadVPMJob loadVPMJob = new LoadVPMJob(splevoProject);
        this.add((IJob)loadVPMJob);
        SaveVPMJob saveVPMJob = new SaveVPMJob(splevoProject, targetPath, refactoringStarted);
        this.add((IJob)saveVPMJob);
        loadVPMJob = new LoadVPMJob(splevoProject);
        this.add((IJob)loadVPMJob);
        this.add((IJob)new OpenVPMJob(splevoProject, null));
    }

    private static String getTargetPath(SPLevoProject splevoProject, String pathSegment) {
        return String.valueOf(splevoProject.getWorkspace()) + String.format("models/vpms/%s-vpm.vpm", pathSegment);
    }
}

