/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.vpm.VPMUtil;
import org.splevo.vpm.variability.VariationPointModel;

public class SaveVPMJob
extends AbstractBlackboardInteractingJob<SPLevoBlackBoard> {
    private SPLevoProject splevoProject;
    private String targetPath;
    private boolean refactoringStarted;

    public SaveVPMJob(SPLevoProject splevoProject, String targetPath, boolean refactoringStarted) {
        this.splevoProject = splevoProject;
        this.targetPath = targetPath;
        this.refactoringStarted = refactoringStarted;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException {
        VariationPointModel vpm = ((SPLevoBlackBoard)this.getBlackboard()).getVariationPointModel();
        this.logger.info((Object)"Save VPM Model");
        try {
            VPMUtil.save((VariationPointModel)vpm, (File)new File(this.targetPath));
            this.splevoProject.addVPMModelReference(this.targetPath, this.refactoringStarted);
        }
        catch (IOException e) {
            throw new JobFailedException("Failed to save vpm model.", (Throwable)e);
        }
        monitor.done();
    }

    public String getName() {
        return "Save VPM model Job";
    }

    public void cleanup(IProgressMonitor arg0) {
    }
}

