/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.vpm.analyzer.VPMAnalyzer;
import org.splevo.vpm.analyzer.VPMAnalyzerException;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.graph.VPMGraph;

public class VPMAnalysisJob
extends AbstractBlackboardInteractingJob<SPLevoBlackBoard> {
    private VPMAnalyzer analyzer;

    public VPMAnalysisJob(VPMAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException {
        VPMAnalyzerResult analyzerResult;
        this.logger.info((Object)"Load VPM Graph");
        VPMGraph vpmGraph = ((SPLevoBlackBoard)this.getBlackboard()).getVpmGraph();
        this.logger.info((Object)"Analyze VPM Graph");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss:S");
        this.logger.info((Object)("VPM Analysis (" + this.analyzer.getName() + ") started at: " + dateFormat.format(new Date())));
        try {
            analyzerResult = this.analyzer.analyze(vpmGraph);
        }
        catch (VPMAnalyzerException e) {
            this.logger.error((Object)("VPM Analysis (" + this.analyzer.getName() + ") failed at: " + dateFormat.format(new Date())));
            throw new JobFailedException("VPM Analysis failed (" + this.analyzer.getName() + ")", (Throwable)e);
        }
        this.logger.info((Object)("VPM Analysis (" + this.analyzer.getName() + ") finished at: " + dateFormat.format(new Date())));
        this.logger.info((Object)("VPM Analysis (" + this.analyzer.getName() + ") relationships detected: " + analyzerResult.getEdgeDescriptors().size()));
        ((SPLevoBlackBoard)this.getBlackboard()).getVpmAnalyzerResults().add(analyzerResult);
        monitor.done();
    }

    public String getName() {
        return "Analyze VPM Job";
    }

    public void cleanup(IProgressMonitor arg0) {
    }
}

