/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.nature;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.splevo.ui.wizards.vpmanalysis.VPMAnalyzerConfigurationPage;

public class AddSPLevoNatureHandler
extends AbstractHandler {
    private Logger logger = Logger.getLogger(VPMAnalyzerConfigurationPage.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbench workbench;
        IWorkbenchWindow activeWindow;
        Shell shell;
        boolean switchPerspective;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null && selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                this.addSPLevoNature(project);
            }
        }
        if (switchPerspective = MessageDialog.openConfirm((Shell)(shell = (activeWindow = (workbench = PlatformUI.getWorkbench()).getActiveWorkbenchWindow()).getShell()), (String)"Open SPLevo Perspective", (String)"SPLevo projects are associated with a specialized perspective.\nDo you want to switch to the SPLevo perspective?")) {
            try {
                workbench.showPerspective("org.splevo.ui.perspective", activeWindow);
            }
            catch (WorkbenchException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void addSPLevoNature(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if ("org.splevo.ui.splevonature".equals(natures[i])) {
                    String[] newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                    description.setNatureIds(newNatures);
                    project.setDescription(description, null);
                    return;
                }
                ++i;
            }
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "org.splevo.ui.splevonature";
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            this.logger.info((Object)"Failed to toggle the project's nature.", (Throwable)e);
        }
    }
}

