/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.refinementbrowser;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.SWTResourceManager;
import org.splevo.ui.SPLevoUIPlugin;
import org.splevo.ui.commons.tooltip.CustomizableDescriptionHavingTreeViewerToolTip;
import org.splevo.ui.refinementbrowser.RefinementGraph;
import org.splevo.ui.refinementbrowser.RefinementTreeContentProviderBase;
import org.splevo.ui.refinementbrowser.action.RefinementBrowserSingleElementAction;
import org.splevo.ui.refinementbrowser.action.RefinementEditDescriptionAction;
import org.splevo.ui.refinementbrowser.action.RenameRefinementAction;
import org.splevo.ui.refinementbrowser.listener.CommandActionMenuListener;
import org.splevo.ui.refinementbrowser.listener.ExpandTreeListener;
import org.splevo.ui.refinementbrowser.listener.HighlightConnectedVPListener;
import org.splevo.ui.refinementbrowser.listener.RefinementDetailsViewSynchronizeListener;
import org.splevo.ui.refinementbrowser.listener.RefinementInfoSelectionListener;
import org.splevo.ui.util.UIUtil;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;

public class RefinementDetailsView
extends Composite {
    private static final String COMMAND_ID_OPENSOURCELOCATION = "org.splevo.ui.commands.opensourcelocation";
    private static final String COMMAND_ID_OPENSOURCELOCATIONDIFF = "org.splevo.ui.commands.opensourcelocationdiff";
    private static final String REFINEMENT_INFO_DEFAULT_TEXT = "Select refinement on the left to review details.";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final boolean VISUALIZATION_ENABLED_DEFAULT = true;
    private TreeViewer refinementDetailsTreeViewer = null;
    private StyledText refinementInfoArea = null;
    private RefinementGraph refinementGraph = null;
    private boolean visualizationEnabled = true;

    public RefinementDetailsView(SashForm parent, IWorkbenchPartSite site) {
        super((Composite)parent, 4);
        this.setLayout((Layout)new FillLayout(256));
        SashForm sashForm = new SashForm((Composite)this, 4);
        sashForm.setSashWidth(1);
        sashForm.setBackground(SWTResourceManager.getColor(1));
        this.refinementDetailsTreeViewer = new TreeViewer((Composite)sashForm, 2050);
        this.refinementDetailsTreeViewer.setLabelProvider((IBaseLabelProvider)new RefinementDetailsLabelProvider());
        this.refinementDetailsTreeViewer.setContentProvider((IContentProvider)new RefinementDetailsTreeContentProvider());
        this.refinementDetailsTreeViewer.addDoubleClickListener((IDoubleClickListener)new ExpandTreeListener());
        this.refinementDetailsTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new RefinementInfoSelectionListener(this));
        this.refinementDetailsTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new HighlightConnectedVPListener());
        this.refinementDetailsTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new RefinementDetailsViewSynchronizeListener());
        this.initContextMenu(this.refinementDetailsTreeViewer, site);
        this.initToolTips(this.refinementDetailsTreeViewer);
        SashForm detailsArea = new SashForm((Composite)sashForm, 4);
        detailsArea.setSashWidth(1);
        detailsArea.setOrientation(512);
        detailsArea.setBackground(SWTResourceManager.getColor(1));
        this.refinementInfoArea = new StyledText((Composite)detailsArea, 2624);
        this.refinementInfoArea.setBackground(SWTResourceManager.getColor(1));
        this.refinementInfoArea.setText(REFINEMENT_INFO_DEFAULT_TEXT);
        this.refinementGraph = new RefinementGraph((Composite)detailsArea, 2048);
        sashForm.setWeights(new int[]{5, 5});
    }

    public void setEnabled(boolean enable) {
        this.refinementDetailsTreeViewer.getControl().setEnabled(enable);
    }

    public void createContents(Composite parent) {
        parent.setEnabled(true);
    }

    public void showRefinement(Refinement refinement) {
        this.setEnabled(true);
        this.refinementDetailsTreeViewer.setInput((Object)refinement);
        if (this.visualizationEnabled) {
            this.refinementGraph.show(refinement);
        }
    }

    public void displayRefinementInfo(String headline, String subHeadline, String info) {
        this.refinementInfoArea.setText(String.valueOf(headline) + LINE_SEPARATOR + LINE_SEPARATOR + subHeadline + LINE_SEPARATOR + info);
        if (!Strings.isNullOrEmpty((String)headline)) {
            StyleRange styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = headline.length();
            styleRange.fontStyle = 1;
            styleRange.underline = true;
            styleRange.underlineStyle = 1;
            this.refinementInfoArea.setStyleRange(styleRange);
            if (!Strings.isNullOrEmpty((String)subHeadline)) {
                styleRange = new StyleRange();
                styleRange.start = headline.length() + 2 * LINE_SEPARATOR.length();
                styleRange.length = subHeadline.length();
                styleRange.fontStyle = 1;
                styleRange.underline = true;
                styleRange.underlineStyle = 0;
                this.refinementInfoArea.setStyleRange(styleRange);
            }
        }
    }

    private void initContextMenu(final TreeViewer viewer, IWorkbenchPartSite site) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                if (!selection.isEmpty() && selection.getFirstElement() instanceof Refinement) {
                    RefinementBrowserSingleElementAction action = new RenameRefinementAction(viewer);
                    manager.add((IAction)action);
                    action = new RefinementEditDescriptionAction(viewer);
                    manager.add((IAction)action);
                }
            }
        });
        menuManager.addMenuListener((IMenuListener)new CommandActionMenuListener(COMMAND_ID_OPENSOURCELOCATION, SPLevoUIPlugin.getImageDescriptor("icons/jcu_obj.gif")));
        menuManager.addMenuListener((IMenuListener)new CommandActionMenuListener(COMMAND_ID_OPENSOURCELOCATIONDIFF, SPLevoUIPlugin.getImageDescriptor("icons/unifieddiff-editor.gif")));
        menuManager.addMenuListener((IMenuListener)new CommandActionMenuListener("org.splevo.ui.commands.argouml.variantscan", SPLevoUIPlugin.getImageDescriptor("icons/kopl_circle_only.png")));
        Menu menu = menuManager.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(menu);
        site.setSelectionProvider((ISelectionProvider)viewer);
    }

    private void initToolTips(TreeViewer viewer) {
        new CustomizableDescriptionHavingTreeViewerToolTip(viewer);
    }

    public void setEnableVisualization(boolean enabled) {
        this.visualizationEnabled = enabled;
        if (!enabled) {
            this.refinementGraph.clear();
        }
    }

    public boolean getEnableVisualizationDefault() {
        return true;
    }

    private static class RefinementDetailsLabelProvider
    extends LabelProvider {
        private RefinementDetailsLabelProvider() {
        }

        public Image getImage(Object element) {
            Image image = UIUtil.getItemProviderImage(element);
            if (image != null) {
                return image;
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }

        public String getText(Object element) {
            String label = UIUtil.getItemProviderText(element);
            if (!Strings.isNullOrEmpty((String)label)) {
                return label;
            }
            return "[UNKNOWN]";
        }
    }

    private static class RefinementDetailsTreeContentProvider
    extends RefinementTreeContentProviderBase<Refinement> {
        private RefinementDetailsTreeContentProvider() {
        }

        @Override
        protected Object[] getElements() {
            LinkedList children = Lists.newLinkedList();
            children.addAll(((Refinement)this.topLevelElement).getSubRefinements());
            children.addAll(((Refinement)this.topLevelElement).getVariationPoints());
            return children.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Refinement) {
                Refinement parentRefinement = (Refinement)parentElement;
                LinkedList children = Lists.newLinkedList();
                children.addAll(parentRefinement.getSubRefinements());
                children.addAll(parentRefinement.getVariationPoints());
                return children.toArray();
            }
            if (parentElement instanceof VariationPoint) {
                return ((VariationPoint)parentElement).getVariants().toArray();
            }
            if (parentElement instanceof Variant) {
                return ((Variant)parentElement).getImplementingElements().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }
    }
}

