/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.sourceconnection.jdt;

import com.google.common.collect.Lists;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.eclipse.wb.swt.ResourceManager;
import org.splevo.ui.refinementbrowser.RefinementDetailsView;
import org.splevo.ui.sourceconnection.jdt.VariantRegistry;
import org.splevo.vpm.software.JavaSoftwareElement;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.software.SourceLocation;
import org.splevo.vpm.variability.Variant;

public class JavaEditorConnector {
    private static Logger logger = Logger.getLogger(RefinementDetailsView.class);
    public static final String LOCATION_ANNOTATION_VARIANT_MULTIPLE = "org.splevo.ui.annotations.variant.multiple";
    public static final String LOCATION_ANNOTATION_VARIANT_SINGLE = "org.splevo.ui.annotations.variant.single";
    public static final String LOCATION_MARKER = "org.splevo.ui.markers.codelocationmarker.variant";
    public static final String LOCATION_MARKER_VARIANT_SINGLE = "org.splevo.ui.markers.codelocation.variant.single";
    public static final String LOCATION_MARKER_ATTRIBUTE_VARIANT = "org.splevo.ui.markers.attribute.variant";
    private static final String ICON = "icons/leading.png";
    private static final String PLUGIN = "org.splevo.ui";

    public ITextEditor openEditor(JavaSoftwareElement softwareElement) {
        SourceLocation sourceLocation = softwareElement.getSourceLocation();
        if (sourceLocation != null) {
            return this.openJavaEditor(sourceLocation, true);
        }
        logger.warn((Object)"No source location accessible.");
        return null;
    }

    private ITextEditor openJavaEditor(SourceLocation sourceLocation, boolean openFileMultipleTimes) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = Path.fromOSString((String)sourceLocation.getFilePath());
        IFile inputFile = workspace.getRoot().getFileForLocation(location);
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ITextEditor iEditorPart = null;
        if (!openFileMultipleTimes) {
            IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                IEditorPart editorTmp = editorReference.getEditor(false);
                if (editorTmp instanceof ITextEditor) {
                    ITextEditor abstractTextEditor = (ITextEditor)editorTmp;
                    if (inputFile.getName().equalsIgnoreCase(abstractTextEditor.getEditorInput().getName())) {
                        iEditorPart = (ITextEditor)editorTmp;
                        break;
                    }
                }
                ++n2;
            }
        }
        if (iEditorPart == null) {
            try {
                iEditorPart = (ITextEditor)IDE.openEditor((IWorkbenchPage)activePage, (IFile)inputFile, (boolean)false);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return iEditorPart;
    }

    public void highlightInTextEditor(ITextEditor editor, String message, Variant variant) {
        int start = Integer.MAX_VALUE;
        int end = 0;
        for (SoftwareElement softwareElement : variant.getImplementingElements()) {
            SourceLocation sourceLocation = softwareElement.getSourceLocation();
            int startElement = sourceLocation.getStartPosition();
            int endElement = sourceLocation.getEndPosition();
            if (startElement < start) {
                start = startElement;
            }
            if (endElement <= end) continue;
            end = endElement;
        }
        int offset = start;
        int length = end - start;
        TextSelection selection = new TextSelection(offset, length);
        try {
            IMarker marker = this.createMarker(editor, message, variant);
            this.createLocationAnnotation(marker, (ITextSelection)selection, editor, variant);
        }
        catch (CoreException e) {
            logger.error((Object)"Could't clear and create text markers.", (Throwable)e);
        }
    }

    private void createLocationAnnotation(IMarker marker, ITextSelection selection, ITextEditor editor, Variant variant) {
        IDocumentProvider idp = editor.getDocumentProvider();
        IEditorInput editorInput = editor.getEditorInput();
        IDocument document = idp.getDocument((Object)editorInput);
        IAnnotationModel annotationModel = idp.getAnnotationModel((Object)editorInput);
        String annotationType = this.getAnnotationType(variant);
        SimpleMarkerAnnotation annotation = new SimpleMarkerAnnotation(annotationType, marker);
        annotationModel.connect(document);
        annotationModel.addAnnotation((Annotation)annotation, new Position(selection.getOffset(), selection.getLength()));
        annotationModel.disconnect(document);
    }

    public void setImageIcon(ITextEditor editor, Variant variant) {
        if (variant.getLeading().booleanValue() && editor instanceof JavaEditor) {
            JavaEditor jEditor = (JavaEditor)editor;
            jEditor.updatedTitleImage(ResourceManager.getPluginImage(PLUGIN, ICON));
        }
    }

    private String getAnnotationType(Variant variant) {
        int variantCount = variant.getVariationPoint().getVariants().size();
        if (variantCount == 1) {
            return LOCATION_ANNOTATION_VARIANT_SINGLE;
        }
        return LOCATION_ANNOTATION_VARIANT_MULTIPLE;
    }

    public void resetLocationHighlighting(ITextEditor editor) {
        IDocumentProvider idp = editor.getDocumentProvider();
        IAnnotationModel annotationModel = idp.getAnnotationModel((Object)editor.getEditorInput());
        Iterator annotationIterator = annotationModel.getAnnotationIterator();
        for (Annotation annotation : Lists.newArrayList((Iterator)annotationIterator)) {
            if (!this.isCodeLocationAnnotation(annotation)) continue;
            annotationModel.removeAnnotation(annotation);
        }
    }

    private boolean isCodeLocationAnnotation(Annotation annotation) {
        return LOCATION_ANNOTATION_VARIANT_MULTIPLE.equals(annotation.getType()) || LOCATION_ANNOTATION_VARIANT_SINGLE.equals(annotation.getType());
    }

    private IMarker createMarker(ITextEditor editor, String message, Variant variant) throws CoreException {
        IFile inputFile = this.getEditorFile(editor);
        if (inputFile != null) {
            IMarker marker = inputFile.createMarker(LOCATION_MARKER);
            marker.setAttribute("message", (Object)message);
            if (variant != null) {
                marker.setAttribute(LOCATION_MARKER_ATTRIBUTE_VARIANT, (Object)VariantRegistry.register(variant));
            }
            return marker;
        }
        logger.warn((Object)"Editor is not handling a file");
        return null;
    }

    public void jumpToLocation(ITextEditor editor, SourceLocation location) {
        editor.selectAndReveal(location.getStartPosition(), 0);
    }

    private IFile getEditorFile(ITextEditor editor) {
        IFile inputFile = null;
        if (editor.getEditorInput() instanceof FileEditorInput) {
            FileEditorInput input = (FileEditorInput)editor.getEditorInput();
            inputFile = input.getFile();
        }
        return inputFile;
    }
}

