/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.sourceconnection.jdt;

import java.util.LinkedList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.PlatformUI;
import org.splevo.ui.sourceconnection.SourceEditorConnector;
import org.splevo.vpm.variability.Variant;

class VartiantLinkQuickFix
implements IMarkerResolution2 {
    private Variant variant;

    public VartiantLinkQuickFix(Variant variant) {
        this.variant = variant;
    }

    public String getLabel() {
        return String.format("Alternative Variant: %s", this.variant.getId());
    }

    public void run(IMarker marker) {
        SourceEditorConnector.openVariant(this.variant, new LinkedList<String>());
    }

    public String getDescription() {
        StringBuilder desc = new StringBuilder();
        desc.append("<b>Double click to jump to the alternative variant implementation</b><br/>");
        for (String code : SourceEditorConnector.getCodeForVariant(this.variant)) {
            desc.append("<br/><code>");
            desc.append(code);
            desc.append("</code>");
        }
        return desc.toString();
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OPEN_MARKER");
    }
}

