/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.wizards.vpmanalysis;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.splevo.ui.wizards.vpmanalysis.UIConfigurationCompositeFactory;
import org.splevo.ui.wizards.vpmanalysis.VPMAnalyzerLabelProvider;
import org.splevo.ui.wizards.vpmanalysis.VPMAnalyzerSelectionDialogListener;
import org.splevo.vpm.analyzer.VPMAnalyzer;

public class VPMAnalyzerConfigurationPage
extends WizardPage {
    private Logger logger = Logger.getLogger(VPMAnalyzerConfigurationPage.class);
    private List<VPMAnalyzer> analyzers = new LinkedList<VPMAnalyzer>();
    private VPMAnalyzer selectedAnalyzer;
    private ListViewer listViewerAnalysis;
    private Composite configComp;
    private ScrolledComposite scrolledComposite;
    private Button rmvBtn;

    public VPMAnalyzerConfigurationPage() {
        super("wizardPage");
        this.setTitle("Analyzer Configuration");
        this.setDescription("Select and configure the variation point model analyzer to be executed.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new FormLayout());
        Composite compAnalyzers = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        compAnalyzers.setLayout((Layout)gridLayout);
        FormData grpAnalyzersFD = new FormData();
        grpAnalyzersFD.top = new FormAttachment(0);
        grpAnalyzersFD.left = new FormAttachment(0, 5);
        grpAnalyzersFD.right = new FormAttachment(30);
        grpAnalyzersFD.bottom = new FormAttachment(100);
        compAnalyzers.setLayoutData((Object)grpAnalyzersFD);
        Label analyzerLabel = new Label(compAnalyzers, 1);
        analyzerLabel.setText("Analyzers");
        analyzerLabel.setLayoutData((Object)new GridData(-1, -1, true, false, 2, 1));
        FontData[] fD = analyzerLabel.getFont().getFontData();
        fD[0].setHeight(12);
        fD[0].setStyle(1);
        analyzerLabel.setFont(new Font((Device)compAnalyzers.getDisplay(), fD[0]));
        this.listViewerAnalysis = new ListViewer(compAnalyzers, 768);
        this.listViewerAnalysis.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.listViewerAnalysis.setInput(this.analyzers);
        this.listViewerAnalysis.setLabelProvider((IBaseLabelProvider)new VPMAnalyzerLabelProvider());
        this.listViewerAnalysis.getList().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.listViewerAnalysis.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VPMAnalyzerConfigurationPage.this.selectedAnalyzer = VPMAnalyzerConfigurationPage.this.getSelectedAnalyzer();
                VPMAnalyzerConfigurationPage.this.update();
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        Button addBtn = new Button(compAnalyzers, 8);
        addBtn.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        addBtn.addMouseListener((MouseListener)new VPMAnalyzerSelectionDialogListener(this));
        addBtn.setLayoutData((Object)gridData);
        this.rmvBtn = new Button(compAnalyzers, 8);
        this.rmvBtn.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_DELETE"));
        this.rmvBtn.setEnabled(false);
        this.rmvBtn.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent arg0) {
                VPMAnalyzerConfigurationPage.this.removeAnalyzer(VPMAnalyzerConfigurationPage.this.selectedAnalyzer);
                VPMAnalyzerConfigurationPage.this.selectedAnalyzer = null;
                VPMAnalyzerConfigurationPage.this.update();
            }
        });
        this.rmvBtn.setLayoutData((Object)gridData);
        Label separator = new Label(container, 514);
        FormData separatorFD = new FormData();
        separatorFD.top = new FormAttachment(0);
        separatorFD.left = new FormAttachment((Control)compAnalyzers, 0);
        separatorFD.bottom = new FormAttachment(100);
        separator.setLayoutData((Object)separatorFD);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment((Control)separator, 5);
        formData.right = new FormAttachment(100, -5);
        formData.bottom = new FormAttachment(100);
        this.scrolledComposite = new ScrolledComposite(container, 512);
        this.scrolledComposite.setLayoutData((Object)formData);
        this.configComp = new Composite((Composite)this.scrolledComposite, 0);
        this.configComp.setLayout((Layout)new FormLayout());
        this.updateConfig();
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = ((ScrolledComposite)e.widget).getClientArea();
                ((ScrolledComposite)e.widget).setMinSize(VPMAnalyzerConfigurationPage.this.configComp.computeSize(r.width - 5, -1));
            }
        });
        this.scrolledComposite.setContent((Control)this.configComp);
    }

    public boolean isPageComplete() {
        return this.analyzers.size() > 0;
    }

    public void addAnalyzer(VPMAnalyzer analyzer) {
        this.analyzers.add(analyzer);
        this.update();
        this.listViewerAnalysis.setSelection((ISelection)new StructuredSelection((Object)analyzer), true);
    }

    public void removeAnalyzer(VPMAnalyzer analyzer) {
        this.analyzers.remove(analyzer);
        this.update();
    }

    public List<VPMAnalyzer> getAnalyzers() {
        return this.analyzers;
    }

    private VPMAnalyzer getSelectedAnalyzer() {
        VPMAnalyzer analyzer = null;
        if (this.listViewerAnalysis.getSelection() instanceof StructuredSelection) {
            Object selection = ((StructuredSelection)this.listViewerAnalysis.getSelection()).getFirstElement();
            if (selection != null) {
                analyzer = (VPMAnalyzer)selection;
            }
        } else {
            this.logger.error((Object)"Invalid selection type in AnalyzerSelectionPage dialog");
        }
        return analyzer;
    }

    private void update() {
        this.updateConfig();
        this.listViewerAnalysis.refresh();
        this.rmvBtn.setEnabled(this.selectedAnalyzer != null);
        this.getWizard().getContainer().updateButtons();
    }

    private void updateConfig() {
        this.disposeAllChildren(this.configComp);
        if (this.selectedAnalyzer == null) {
            Label label = new Label(this.configComp, 0);
            label.setText("Please select a VPM Analyzer first.");
            this.configComp.pack();
        } else {
            new UIConfigurationCompositeFactory(this.selectedAnalyzer).createConfigComps(this.configComp);
        }
        this.configComp.setSize(this.configComp.computeSize(-1, -1));
        Rectangle r = this.scrolledComposite.getClientArea();
        this.scrolledComposite.setMinSize(this.configComp.computeSize(r.width - 5, -1));
    }

    private void disposeAllChildren(Composite composite) {
        Control[] controlArray = this.configComp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
    }
}

