/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.wizards.vpmanalysis;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.splevo.ui.wizards.vpmanalysis.VPMAnalyzerConfigurationPage;
import org.splevo.ui.wizards.vpmanalysis.VPMAnalyzerLabelProvider;
import org.splevo.vpm.analyzer.DefaultVPMAnalyzerService;
import org.splevo.vpm.analyzer.VPMAnalyzer;
import org.splevo.vpm.analyzer.VPMAnalyzerService;

public class VPMAnalyzerSelectionDialogListener
extends MouseAdapter {
    private VPMAnalyzerConfigurationPage page = null;
    private VPMAnalyzerService vpmAnalyzerService = new DefaultVPMAnalyzerService();

    public VPMAnalyzerSelectionDialogListener(VPMAnalyzerConfigurationPage page) {
        this.page = page;
    }

    public void mouseUp(MouseEvent e) {
        Object analyzerObject;
        Shell shell = e.widget.getDisplay().getActiveShell();
        ArrayList availableAnalyzer = Lists.newArrayList((Iterable)this.vpmAnalyzerService.getAvailableAnalyzers());
        availableAnalyzer.removeAll(this.page.getAnalyzers());
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new VPMAnalyzerLabelProvider());
        dialog.setTitle("VPM Analyzer Selection");
        dialog.setMessage("Select an analyzer by name (* = any string, ? = any char):");
        dialog.setElements(availableAnalyzer.toArray());
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        if (result == 0 && (analyzerObject = dialog.getFirstResult()) != null) {
            VPMAnalyzer analyzer = (VPMAnalyzer)analyzerObject;
            this.page.addAnalyzer(analyzer);
        }
    }
}

