/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.workflow;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.ui.UIBasedWorkflow;
import de.uka.ipd.sdq.workflow.workbench.AbstractWorkbenchDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.editors.SPLevoProjectEditor;
import org.splevo.ui.jobs.LoadVPMJob;
import org.splevo.ui.jobs.OpenVPMJob;
import org.splevo.ui.jobs.RefactorVPMJob;
import org.splevo.ui.jobs.RefreshLeadingCopyProjects;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.ui.jobs.SaveAndReloadVPMJob;
import org.splevo.ui.jobs.SetVPMModelReferenceRefactoredStatus;
import org.splevo.ui.workflow.BuildSPLWorkflowConfiguration;

public class BuildSPLWorkflowDelegate
extends AbstractWorkbenchDelegate<BuildSPLWorkflowConfiguration, UIBasedWorkflow<Blackboard<?>>> {
    private BuildSPLWorkflowConfiguration config;
    private SPLevoBlackBoard blackboard;

    public BuildSPLWorkflowDelegate(BuildSPLWorkflowConfiguration config, SPLevoBlackBoard blackboard) {
        this.config = config;
        this.blackboard = blackboard;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected IJob createWorkflowJob(BuildSPLWorkflowConfiguration arg0) {
        SPLevoProjectEditor splevoProjectEditor = this.config.getSplevoProjectEditor();
        SPLevoProject splevoProject = splevoProjectEditor.getSplevoProject();
        SequentialBlackboardInteractingJob jobSequence = new SequentialBlackboardInteractingJob();
        jobSequence.setBlackboard((Blackboard)this.blackboard);
        jobSequence.add((IJob)new SaveAndReloadVPMJob(splevoProject, "refactored", false));
        LoadVPMJob loadVPMJob = new LoadVPMJob(splevoProject);
        jobSequence.add((IJob)loadVPMJob);
        RefactorVPMJob refactorVPMJob = new RefactorVPMJob(splevoProject);
        jobSequence.add((IJob)refactorVPMJob);
        jobSequence.add((IJob)new RefreshLeadingCopyProjects(splevoProject));
        jobSequence.add((IJob)new SetVPMModelReferenceRefactoredStatus(splevoProjectEditor, true));
        LoadVPMJob loadVPMJobAfterRefactoring = new LoadVPMJob(splevoProject);
        jobSequence.add((IJob)loadVPMJobAfterRefactoring);
        jobSequence.add((IJob)new OpenVPMJob(splevoProject, null));
        return jobSequence;
    }

    protected BuildSPLWorkflowConfiguration getConfiguration() {
        return this.config;
    }

    protected boolean useSeparateConsoleForEachJobRun() {
        return false;
    }
}

