/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.editors;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.splevo.ui.editors.UnifiedDiffEditorInput;
import org.splevo.ui.editors.UnifiedDiffHighlighter;
import org.splevo.ui.editors.UnifiedDiffRulerColumn;
import org.splevo.ui.sourceconnection.UnifiedDiffConnectorModel;

public class UnifiedDiffEditor
extends TextEditor {
    private static final Logger LOGGER = Logger.getLogger(UnifiedDiffEditor.class);
    private UnifiedDiffEditorInput input;
    private CompositeRuler ruler;

    protected void initializeEditor() {
        super.initializeEditor();
        JavaTextTools javaTextTools = JavaPlugin.getDefault().getJavaTextTools();
        JavaSourceViewerConfiguration sourceViewerConfiguration = new JavaSourceViewerConfiguration(javaTextTools.getColorManager(), JavaPlugin.getDefault().getCombinedPreferenceStore(), (ITextEditor)this, "___java_partitioning");
        this.setSourceViewerConfiguration((SourceViewerConfiguration)sourceViewerConfiguration);
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.done();
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.removeAll();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.getEditorInput() instanceof UnifiedDiffEditorInput) {
            this.input = (UnifiedDiffEditorInput)this.getEditorInput();
        } else {
            LOGGER.warn((Object)("The editor input of the UnifiedDiffEditor instance is not of type UnifiedDiffEditorInput but of type " + this.getEditorInput().getClass().getSimpleName() + "! This may lead to some operations not functioning as " + "intended."));
        }
        if (this.input instanceof UnifiedDiffEditorInput) {
            this.setPartName(this.input.getName());
            UnifiedDiffConnectorModel content = this.input.getDiffConnectorModel();
            UnifiedDiffHighlighter diffHighlighter = new UnifiedDiffHighlighter(this);
            Map<Integer, Color> unifiedLinesToColorMapping = diffHighlighter.highlightLines();
            int columnCount = content.getIntegrationCopyCount() + 1;
            int i = 0;
            while (i < columnCount) {
                UnifiedDiffRulerColumn column = new UnifiedDiffRulerColumn(i, content.getUnifiedLineNumbers(), unifiedLinesToColorMapping);
                this.ruler.addDecorator(i, (IVerticalRulerColumn)column);
                ++i;
            }
        } else {
            throw new RuntimeException("The editor input of the UnifiedDiffEditor instance is not of type UnifiedDiffEditorInput but of type " + ((Object)((Object)this.input)).getClass().getSimpleName() + ".");
        }
    }

    protected IVerticalRuler createVerticalRuler() {
        this.ruler = (CompositeRuler)super.createVerticalRuler();
        return this.ruler;
    }

    public UnifiedDiffConnectorModel getDiffConnectorModel() {
        if (this.input != null && this.input instanceof UnifiedDiffEditorInput) {
            return this.input.getDiffConnectorModel();
        }
        if (this.input == null && this.getEditorInput() instanceof UnifiedDiffEditorInput) {
            return ((UnifiedDiffEditorInput)this.getEditorInput()).getDiffConnectorModel();
        }
        throw new RuntimeException("The editor input of the UnifiedDiffEditor instance is not set or the instance is not of type UnifiedDiffEditorInput but of type " + ((Object)((Object)this.input)).getClass().getSimpleName() + ".");
    }

    public ISourceViewer getViewer() {
        return super.getSourceViewer();
    }
}

